<?php
// چک کردن لاگین (ساده شده)
if (!isset($_SESSION['user'])) {
    // لاگین خودکار ماک برای دمو
    $_SESSION['user'] = ['name' => 'شهروند گرامی', 'id' => '0012345678'];
}
$user = $_SESSION['user'];
?>

<div class="bg-slate-100 min-h-[calc(100vh-80px)]">
    <div class="max-w-6xl mx-auto md:flex">
        
        <aside class="md:w-64 bg-white md:min-h-screen border-l border-slate-200 p-4 hidden md:block">
            <div class="text-center mb-6 pb-6 border-b border-slate-100">
                <div class="w-16 h-16 bg-slate-200 rounded-full mx-auto mb-3 flex items-center justify-center text-slate-400">
                    <?php echo render_icon('user', 'w-8 h-8'); ?>
                </div>
                <h3 class="font-bold"><?php echo $user['name']; ?></h3>
                <p class="text-xs text-slate-500 font-mono mt-1"><?php echo $user['id']; ?></p>
            </div>
            <nav class="space-y-1">
                <a href="#" class="flex items-center gap-3 px-3 py-2 bg-blue-50 text-blue-700 rounded-lg font-medium">
                    <?php echo render_icon('home', 'w-5 h-5'); ?> داشبورد
                </a>
                <a href="#" class="flex items-center gap-3 px-3 py-2 text-slate-600 hover:bg-slate-50 rounded-lg">
                    <?php echo render_icon('document', 'w-5 h-5'); ?> استعلام‌های من
                </a>
            </nav>
        </aside>

        <div class="flex-1 p-4 md:p-8">
            <h2 class="text-2xl font-bold mb-6 text-slate-800">داشبورد کاربری</h2>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-8">
                <div class="bg-white p-5 rounded-xl border border-slate-200 shadow-sm">
                    <span class="text-slate-500 text-sm">مجموع سهمیه تخصیصی</span>
                    <div class="text-2xl font-bold text-gov-primary mt-1"><?php echo fa_number('2.5'); ?> <span class="text-sm font-normal">گرم</span></div>
                </div>
                <div class="bg-white p-5 rounded-xl border border-slate-200 shadow-sm">
                    <span class="text-slate-500 text-sm">وضعیت تحویل</span>
                    <div class="inline-block px-2 py-1 bg-yellow-100 text-yellow-800 text-xs rounded mt-2">در انتظار رزرو وقت</div>
                </div>
            </div>

            <div class="bg-white rounded-xl border border-slate-200 shadow-sm overflow-hidden">
                <div class="px-6 py-4 border-b border-slate-100 bg-slate-50 flex justify-between items-center">
                    <h3 class="font-bold">تاریخچه استعلام‌ها</h3>
                    <span class="text-xs text-slate-500">آخرین بروزرسانی: دقایقی پیش</span>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full text-sm text-right">
                        <thead class="bg-slate-50 text-slate-500">
                            <tr>
                                <th class="px-6 py-3">کد پیگیری</th>
                                <th class="px-6 py-3">تاریخ</th>
                                <th class="px-6 py-3">مبلغ</th>
                                <th class="px-6 py-3">وضعیت</th>
                                <th class="px-6 py-3">عملیات</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-slate-100">
                            <?php foreach($_SESSION['inquiries'] as $inq): ?>
                            <tr class="hover:bg-slate-50/50">
                                <td class="px-6 py-4 font-mono text-slate-600"><?php echo $inq['id']; ?></td>
                                <td class="px-6 py-4"><?php echo $inq['date']; ?></td>
                                <td class="px-6 py-4"><?php echo fa_number(number_format($inq['amount'])); ?> تومان</td>
                                <td class="px-6 py-4">
                                    <?php if($inq['status'] == 'ready'): ?>
                                        <span class="px-2 py-1 bg-green-100 text-green-700 rounded-full text-xs">نتیجه آماده</span>
                                    <?php else: ?>
                                        <span class="px-2 py-1 bg-orange-100 text-orange-700 rounded-full text-xs">در انتظار پاسخ</span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4">
                                    <?php if($inq['status'] == 'ready'): ?>
                                        <button class="text-blue-600 hover:underline">مشاهده جزئیات</button>
                                    <?php else: ?>
                                        <span class="text-slate-400 cursor-not-allowed">---</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>