<div class="max-w-2xl mx-auto px-4 py-10">
    <div class="text-center mb-8">
        <h2 class="text-2xl font-bold text-gov-primary mb-2">استعلام وضعیت سهمیه طلا</h2>
        <p class="text-slate-500 text-sm">جهت استعلام، اطلاعات هویتی مالک سیم‌کارت را وارد نمایید.</p>
    </div>

    <div class="bg-white rounded-2xl shadow-lg border border-slate-200 overflow-hidden" id="inquiry-card">
        
        <div id="step-1" class="p-6 md:p-8 space-y-6">
            <?php alert_box('info', 'هزینه استعلام', 'هزینه هر بار استعلام از سامانه ثبت احوال و بانک مرکزی ۵,۰۰۰ تومان می‌باشد.'); ?>
            
            <form onsubmit="goToPayment(event)">
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-1">کد ملی</label>
                        <input type="tel" maxlength="10" required class="w-full border border-slate-300 rounded-lg px-3 py-3 text-center tracking-widest focus:ring-2 focus:ring-gov-primary focus:border-transparent outline-none" placeholder="----------">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-1">شماره همراه</label>
                        <input type="tel" maxlength="11" required class="w-full border border-slate-300 rounded-lg px-3 py-3 text-center tracking-widest focus:ring-2 focus:ring-gov-primary focus:border-transparent outline-none" placeholder="09xxxxxxxxx">
                    </div>
                    
                    <div class="flex items-start gap-2 text-sm text-slate-600 bg-slate-50 p-3 rounded">
                        <input type="checkbox" required class="mt-1">
                        <label>قوانین و مقررات سامانه را مطالعه کرده و می‌پذیرم. مسئولیت صحت اطلاعات بر عهده کاربر است.</label>
                    </div>
                </div>

                <button type="submit" class="w-full bg-gov-primary text-white font-bold py-3 rounded-xl mt-6 hover:bg-gov-secondary transition shadow-md">
                    ادامه و پرداخت هزینه (۵,۰۰۰ تومان)
                </button>
            </form>
        </div>

        <div id="step-2" class="hidden p-6 md:p-8 text-center space-y-6">
            <div class="w-16 h-16 bg-blue-100 text-blue-600 rounded-full flex items-center justify-center mx-auto animate-pulse">
                <svg class="w-8 h-8" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z" /></svg>
            </div>
            <h3 class="text-xl font-bold">درگاه پرداخت اینترنتی (شبیه‌ساز)</h3>
            <div class="bg-slate-50 p-4 rounded-lg border border-slate-200 inline-block w-full">
                <div class="flex justify-between mb-2">
                    <span class="text-slate-500">مبلغ قابل پرداخت:</span>
                    <span class="font-bold text-lg">۵۰,۰۰۰ ریال</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-slate-500">پذیرنده:</span>
                    <span>خزانه داری کل کشور</span>
                </div>
            </div>
            <button onclick="processPayment()" class="w-full bg-green-600 text-white font-bold py-3 rounded-xl hover:bg-green-700 transition shadow-lg">
                پرداخت و تکمیل فرایند
            </button>
            <button onclick="location.reload()" class="text-sm text-red-500 mt-2">انصراف</button>
        </div>

        <div id="step-3" class="hidden p-6 md:p-8 text-center space-y-6">
            <div class="w-20 h-20 bg-green-100 text-green-600 rounded-full flex items-center justify-center mx-auto">
                <svg class="w-10 h-10" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" /></svg>
            </div>
            <div>
                <h3 class="text-xl font-bold text-green-700">پرداخت با موفقیت انجام شد</h3>
                <p class="text-slate-500 mt-2">درخواست شما در سامانه ثبت گردید.</p>
            </div>
            
            <div class="bg-blue-50 border border-blue-200 p-4 rounded-lg text-right text-sm space-y-2">
                <div class="flex justify-between">
                    <span>کد پیگیری:</span>
                    <span class="font-mono font-bold">ST-<?php echo rand(1000,9999); ?></span>
                </div>
                <div class="flex justify-between">
                    <span>زمان تخمینی پاسخ:</span>
                    <span class="font-bold text-orange-600">۳۰ تا ۴۵ دقیقه آینده</span>
                </div>
            </div>

            <div class="bg-yellow-50 text-yellow-800 text-xs p-3 rounded text-right">
                توجه: نتیجه استعلام پس از بررسی در سامانه مرکزی، در پنل کاربری شما قابل مشاهده خواهد بود. لطفاً صبور باشید.
            </div>

            <a href="index.php?page=dashboard" class="block w-full bg-gov-primary text-white font-bold py-3 rounded-xl hover:bg-gov-secondary transition">
                ورود به پنل کاربری جهت مشاهده نتیجه
            </a>
        </div>

    </div>
</div>

<script>
function goToPayment(e) {
    e.preventDefault();
    document.getElementById('step-1').classList.add('hidden');
    document.getElementById('step-2').classList.remove('hidden');
}

function processPayment() {
    // شبیه‌سازی لودینگ پرداخت
    const btn = event.target;
    const originalText = btn.innerText;
    btn.innerText = 'در حال ارتباط با بانک...';
    btn.disabled = true;

    setTimeout(() => {
        document.getElementById('step-2').classList.add('hidden');
        document.getElementById('step-3').classList.remove('hidden');
        
        // در اینجا در یک سیستم واقعی باید درخواست ایجکس به سرور فرستاده شود
        // تا پرداخت در دیتابیس ثبت شود.
    }, 2000);
}
</script>