<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>سامانه ملی سهمیه طلای دولت</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazirmatn@v33.003/Vazirmatn-font-face.css" rel="stylesheet" type="text/css" />
    <style>
        body { font-family: 'Vazirmatn', sans-serif; }
        .bg-gov-primary { background-color: #0f4c81; }
        .bg-gov-secondary { background-color: #1e3a8a; }
        .text-gov-primary { color: #0f4c81; }
    </style>
</head>
<body class="bg-slate-50 text-slate-800 flex flex-col min-h-screen">

<header class="bg-gov-primary text-white shadow-lg sticky top-0 z-50">
    <div class="max-w-6xl mx-auto px-4 h-20 flex items-center justify-between">
        <div class="flex items-center gap-4">
            <div class="w-12 h-12 bg-white rounded-full flex items-center justify-center p-1">
                <img src="assets/images/logo.png" alt="آرم جمهوری اسلامی" class="w-full h-full object-contain opacity-80" onerror="this.src='https://upload.wikimedia.org/wikipedia/commons/thumb/5/5a/Emblem_of_Iran.svg/1200px-Emblem_of_Iran.svg.png'">
            </div>
            <div>
                <h1 class="text-lg md:text-xl font-bold leading-tight">سامانه ملی سهمیه طلای دولت برای مردم</h1>
                <p class="text-xs text-blue-200 mt-0.5">زیر نظر وزارت امور اقتصادی و دارایی</p>
            </div>
        </div>

        <div class="hidden md:flex items-center gap-6 text-sm font-medium">
            <a href="index.php" class="hover:text-blue-200 transition">صفحه اصلی</a>
            <a href="index.php?page=check" class="hover:text-blue-200 transition">استعلام سهمیه</a>
            <a href="index.php?page=news" class="hover:text-blue-200 transition">اخبار و اطلاعیه‌ها</a>
            
            <?php if(isset($_SESSION['user'])): ?>
                <a href="index.php?page=dashboard" class="bg-white/10 hover:bg-white/20 px-4 py-2 rounded-full transition flex items-center gap-2">
                    <?php echo render_icon('user', 'w-4 h-4'); ?>
                    پنل کاربری
                </a>
            <?php else: ?>
                <a href="index.php?page=login" class="bg-white text-gov-primary hover:bg-blue-50 px-5 py-2 rounded-xl shadow transition font-bold">
                    ورود به پنل
                </a>
            <?php endif; ?>
        </div>

        <button class="md:hidden text-white" onclick="document.getElementById('mobile-menu').classList.toggle('hidden')">
            <?php echo render_icon('menu', 'w-8 h-8'); ?>
        </button>
    </div>

    <div id="mobile-menu" class="hidden md:hidden bg-gov-secondary border-t border-blue-800 p-4">
        <nav class="flex flex-col gap-3 text-sm">
            <a href="index.php" class="block p-2 rounded hover:bg-white/10">صفحه اصلی</a>
            <a href="index.php?page=check" class="block p-2 rounded hover:bg-white/10">استعلام سهمیه</a>
            <a href="index.php?page=dashboard" class="block p-2 rounded hover:bg-white/10">پنل کاربری</a>
        </nav>
    </div>
</header>
<main class="flex-grow">