<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>بازی سکسی - ثبت‌نام و پنل کاربری</title>
    <link rel="shortcut icon" href="img/favicon.ico" type="image/x-icon">
    <link rel="apple-touch-icon" type="image/x-icon" href="img/apple-touch-icon-57x57-precomposed.png">
    <link rel="apple-touch-icon" type="image/x-icon" sizes="72x72" href="img/apple-touch-icon-72x72-precomposed.png">
    <link rel="apple-touch-icon" type="image/x-icon" sizes="114x114" href="img/apple-touch-icon-114x114-precomposed.png">
    <link rel="apple-touch-icon" type="image/x-icon" sizes="144x144" href="img/apple-touch-icon-144x144-precomposed.png">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Rubik:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #8A2BE2;
            --primary-dark: #6A1BB0;
            --primary-light: #AE6EFF;
            --accent: #FFD700;
            --accent-pink: #FF4D94;
            --dark: #2C0A4D;
            --light: #F8F0FF;
            --text: #333333;
            --success: #00B894;
            --border-radius: 20px;
            --box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Rubik', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background: linear-gradient(135deg, var(--dark), var(--primary-dark));
            color: var(--light);
            min-height: 100vh;
            overflow-x: hidden;
            position: relative;
            padding: 20px;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        
        body::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: 
                radial-gradient(circle at 10% 20%, var(--primary-light), transparent 25%),
                radial-gradient(circle at 90% 80%, var(--primary), transparent 30%);
            opacity: 0.3;
            z-index: -1;
            transition: filter 0.3s ease;
        }
        
        /* استایل‌های فرم ثبت‌نام */
        .container {
            width: 100%;
            max-width: 1200px;
            background: rgba(44, 10, 77, 0.7);
            border-radius: 20px;
            box-shadow: 0 15px 50px rgba(0, 0, 0, 0.3);
            display: flex;
            flex-direction: row;
            overflow: hidden;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .content-left {
            flex: 1;
            background: linear-gradient(135deg, var(--primary-dark) 0%, var(--dark) 100%);
            color: white;
            padding: 40px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            position: relative;
            min-height: 600px;
        }
        
        .content-left h2 {
            font-size: 2.5rem;
            margin-bottom: 20px;
            font-weight: 700;
            text-shadow: 1px 1px 3px rgba(0, 0, 0, 0.2);
            color: var(--accent-pink);
        }
        
        .content-left p {
            font-size: 1.2rem;
            margin-bottom: 30px;
            opacity: 0.9;
        }
        
        .btn-start {
            display: inline-block;
            background: var(--accent-pink);
            color: white;
            padding: 15px 30px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 600;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.15);
            transition: all 0.3s;
            text-align: center;
            margin-top: 20px;
            border: none;
            cursor: pointer;
            animation: pulsePink 2s infinite;
        }
        
        .btn-start:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(255, 77, 148, 0.4);
            background: #FF3A8A;
        }
        
        .copyright {
            position: absolute;
            bottom: 20px;
            right: 40px;
            font-size: 0.9rem;
            opacity: 0.7;
        }
        
        .content-right {
            flex: 1.2;
            padding: 40px;
            overflow-y: auto;
            max-height: 600px;
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
        }
        
        .wizard-container {
            position: relative;
        }
        
        .progress-bar {
            height: 10px;
            background-color: rgba(255, 255, 255, 0.1);
            border-radius: 10px;
            margin-bottom: 30px;
            overflow: hidden;
        }
        
        .progress {
            height: 100%;
            background: linear-gradient(to right, var(--accent-pink), var(--primary));
            border-radius: 10px;
            width: 20%;
            transition: width 0.5s;
        }
        
        .step {
            display: none;
            background: transparent;
        }
        
        .step.active {
            display: block;
            animation: fadeIn 0.5s;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .main_question {
            font-size: 1.5rem;
            margin-bottom: 25px;
            color: var(--accent-pink);
            font-weight: 600;
            padding-bottom: 15px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .checkbox-container {
            display: block;
            position: relative;
            padding: 15px 15px 15px 50px;
            margin-bottom: 15px;
            cursor: pointer;
            font-size: 1.1rem;
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 10px;
            transition: all 0.3s;
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
        }
        
        .checkbox-container:hover {
            border-color: var(--accent-pink);
            background-color: rgba(255, 77, 148, 0.1);
            transform: translateX(-5px);
        }
        
        .checkbox-container input {
            position: absolute;
            opacity: 0;
            cursor: pointer;
        }
        
        .checkmark {
            position: absolute;
            top: 50%;
            left: 15px;
            transform: translateY(-50%);
            height: 25px;
            width: 25px;
            background-color: rgba(255, 255, 255, 0.1);
            border-radius: 5px;
            border: 2px solid rgba(255, 255, 255, 0.2);
            transition: all 0.3s;
        }
        
        .checkbox-container input:checked ~ .checkmark {
            background: linear-gradient(to right, var(--accent-pink), var(--primary));
            border-color: var(--accent-pink);
        }
        
        .checkmark:after {
            content: "";
            position: absolute;
            display: none;
            left: 7px;
            top: 3px;
            width: 7px;
            height: 12px;
            border: solid white;
            border-width: 0 3px 3px 0;
            transform: rotate(45deg);
        }
        
        .checkbox-container input:checked ~ .checkmark:after {
            display: block;
        }
        
        .form-group {
            margin-bottom: 20px;
            position: relative;
        }
        
        .form-control {
            width: 100%;
            padding: 15px;
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 10px;
            font-size: 1rem;
            transition: all 0.3s;
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
            color: white;
        }
        
        .form-control:focus {
            border-color: var(--accent-pink);
            outline: none;
            box-shadow: 0 0 0 3px rgba(255, 77, 148, 0.2);
        }
        
        .form-control.error {
            border-color: var(--accent-pink);
        }
        
        .error-message {
            color: var(--accent-pink);
            font-size: 0.85rem;
            margin-top: 5px;
            display: none;
        }
        
        .age-slider {
            margin: 40px 0;
        }
        
        .slider-container {
            position: relative;
            padding: 0 20px;
        }
        
        .slider {
            -webkit-appearance: none;
            width: 100%;
            height: 10px;
            border-radius: 5px;
            background: rgba(255, 255, 255, 0.1);
            outline: none;
        }
        
        .slider::-webkit-slider-thumb {
            -webkit-appearance: none;
            appearance: none;
            width: 25px;
            height: 25px;
            border-radius: 50%;
            background: linear-gradient(to right, var(--accent-pink), var(--primary));
            cursor: pointer;
            box-shadow: 0 4px 10px rgba(183, 111, 228, 0.5);
        }
        
        .slider-value {
            text-align: center;
            font-size: 1.2rem;
            margin-top: 15px;
            color: var(--accent-pink);
            font-weight: 600;
        }
        
        .wizard-buttons {
            display: flex;
            justify-content: space-between;
            margin-top: 30px;
        }
        
        .btn {
            padding: 12px 25px;
            border: none;
            border-radius: 10px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .btn-back {
            background: rgba(255, 255, 255, 0.1);
            color: rgba(255, 255, 255, 0.8);
        }
        
        .btn-back:hover {
            background: rgba(255, 255, 255, 0.2);
        }
        
        .btn-next, .btn-submit {
            background: linear-gradient(to right, var(--accent-pink), var(--primary));
            color: white;
            box-shadow: 0 4px 15px rgba(183, 111, 228, 0.4);
        }
        
        .btn-next:hover, .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 7px 20px rgba(183, 111, 228, 0.5);
        }
        
        .btn-submit {
            padding: 15px 30px;
            width: 100%;
        }
        
        .summary {
            background: rgba(255, 255, 255, 0.05);
            padding: 20px;
            border-radius: 10px;
            border: 1px solid rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
        }
        
        .summary h5 {
            color: var(--accent-pink);
            font-weight: 600;
            margin-bottom: 15px;
        }
        
        .summary p {
            margin-bottom: 15px;
            line-height: 1.8;
            color: rgba(255, 255, 255, 0.9);
        }
        
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.7);
            z-index: 1000;
            justify-content: center;
            align-items: center;
        }
        
        .modal-content {
            background: linear-gradient(135deg, var(--primary-dark), var(--dark));
            padding: 30px;
            border-radius: 15px;
            max-width: 500px;
            width: 90%;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.3);
            border: 2px solid var(--accent-pink);
        }
        
        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .modal-header h3 {
            color: var(--accent-pink);
            font-weight: 600;
        }
        
        .close-modal {
            background: none;
            border: none;
            font-size: 1.5rem;
            cursor: pointer;
            color: rgba(255, 255, 255, 0.7);
        }
        
        .modal-body {
            line-height: 1.8;
            margin-bottom: 20px;
            color: rgba(255, 255, 255, 0.9);
        }
        
        .modal-footer {
            text-align: left;
        }
        
        .gif-container {
            text-align: center;
            margin: 20px 0;
        }
        
        .gif-image {
            width: 100%;
            max-width: 300px;
            height: auto;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
            border: 2px solid var(--accent-pink);
        }
        
        @keyframes pulsePink {
            0% {
                box-shadow: 0 0 0 0 rgba(255, 77, 148, 0.7);
            }
            70% {
                box-shadow: 0 0 0 15px rgba(255, 77, 148, 0);
            }
            100% {
                box-shadow: 0 0 0 0 rgba(255, 77, 148, 0);
            }
        }
        
        /* استایل‌های پنل کاربری */
        #panel-section {
            display: none;
            width: 100%;
        }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(10px);
            border-radius: var(--border-radius);
            padding: 15px 25px;
            margin-bottom: 30px;
            box-shadow: var(--box-shadow);
        }

        .logo {
            font-weight: 800;
            font-size: 1.8rem;
            color: white;
            display: flex;
            align-items: center;
        }

        .menu-icon {
            font-size: 1.5rem;
            color: white;
            cursor: pointer;
            transition: var(--transition);
        }

        .menu-icon:hover {
            transform: rotate(90deg);
        }

        .main-content {
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            overflow: hidden;
            margin-bottom: 30px;
        }

        .status-section {
            padding: 40px;
            text-align: center;
            background: linear-gradient(135deg, #fdfcfb 0%, #f5f7fa 100%);
        }

        .status-icon {
            font-size: 4rem;
            margin-bottom: 20px;
            color: var(--primary);
        }

        .status-title {
            font-weight: 800;
            font-size: 2rem;
            color: var(--primary);
            margin-bottom: 15px;
        }

        .status-text {
            font-size: 1.2rem;
            color: #666;
            line-height: 1.8;
            margin-bottom: 10px;
        }

        .payment-btn {
            background: var(--accent-pink);
            color: white;
            padding: 12px 30px;
            border-radius: 50px;
            display: inline-block;
            margin: 20px 0;
            font-weight: 600;
            font-size: 1.2rem;
            cursor: pointer;
            transition: var(--transition);
            border: none;
            animation: pulsePink 2s infinite;
        }

        .payment-btn:hover {
            background: #FF3A8A;
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }

        .plans-section {
            padding: 40px;
            background: white;
        }

        .section-title {
            font-weight: 700;
            color: var(--primary);
            font-size: 1.8rem;
            margin-bottom: 30px;
            text-align: center;
        }

        .plans-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 25px;
        }

        .plan-card {
            background: var(--light);
            border-radius: var(--border-radius);
            padding: 25px;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            transition: var(--transition);
            position: relative;
            cursor: pointer;
            border: 2px solid transparent;
        }

        .plan-card.locked {
            opacity: 0.7;
            cursor: not-allowed;
        }

        .plan-card.unlocked {
            opacity: 1;
            cursor: pointer;
            border-color: var(--success);
        }

        .plan-card.locked:after {
            content: "🔒";
            position: absolute;
            top: 15px;
            left: 15px;
            font-size: 1.5rem;
        }

        .plan-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
            border-color: var(--primary);
        }

        .plan-icon {
            font-size: 2.5rem;
            margin-bottom: 15px;
            color: var(--primary);
        }

        .plan-title {
            font-weight: 700;
            font-size: 1.3rem;
            margin-bottom: 10px;
            color: var(--dark);
        }

        .plan-description {
            color: #666;
            line-height: 1.6;
        }

        .profile-panel {
            position: fixed;
            top: 0;
            right: -400px;
            width: 380px;
            height: 100vh;
            background: white;
            box-shadow: -5px 0 25px rgba(0, 0, 0, 0.15);
            z-index: 1000;
            transition: var(--transition);
            padding: 30px;
            overflow-y: auto;
        }

        .profile-panel.active {
            right: 0;
        }

        .panel-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px solid #eee;
        }

        .panel-title {
            font-weight: 700;
            font-size: 1.5rem;
            color: var(--primary);
        }

        .close-panel {
            font-size: 1.5rem;
            color: #999;
            cursor: pointer;
            transition: var(--transition);
        }

        .close-panel:hover {
            color: var(--accent-pink);
            transform: rotate(90deg);
        }

        .profile-info {
            margin-bottom: 30px;
        }

        .info-group {
            margin-bottom: 20px;
        }

        .info-label {
            font-weight: 600;
            color: #666;
            margin-bottom: 5px;
            display: block;
        }

        .info-value {
            font-size: 1.1rem;
            color: var(--dark);
            padding: 10px 15px;
            background: #f9f9f9;
            border-radius: var(--border-radius);
        }

        .overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 999;
            display: none;
        }

        .overlay.active {
            display: block;
        }

        .modal {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background: white;
            border-radius: var(--border-radius);
            padding: 30px;
            box-shadow: var(--box-shadow);
            z-index: 1001;
            text-align: center;
            display: none;
            width: 90%;
            max-width: 400px;
        }

        .modal.active {
            display: block;
        }

        .modal-icon {
            font-size: 3rem;
            color: var(--accent-pink);
            margin-bottom: 20px;
        }

        .modal-title {
            font-weight: 700;
            font-size: 1.5rem;
            margin-bottom: 15px;
            color: var(--dark);
        }

        .modal-text {
            color: #666;
            line-height: 1.6;
            margin-bottom: 25px;
        }

        .modal-close {
            background: var(--primary);
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: 50px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
        }

        .modal-close:hover {
            background: var(--primary-dark);
            transform: translateY(-3px);
        }
        
        .close-modal {
            position: absolute;
            top: 15px;
            left: 15px;
            font-size: 1.5rem;
            color: #999;
            cursor: pointer;
            transition: var(--transition);
            z-index: 1;
        }

        .close-modal:hover {
            color: var(--accent-pink);
            transform: rotate(90deg);
        }
        
        .logout-btn {
            background: var(--accent-pink);
            color: white;
            padding: 10px 20px;
            border-radius: 50px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            border: none;
            margin-top: 20px;
            width: 100%;
        }
        
        .logout-btn:hover {
            background: #FF3A8A;
            transform: translateY(-2px);
        }

        /* مودال تایید سن */
        .age-verification {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 9999;
            justify-content: center;
            align-items: center;
        }
        
        .verification-box {
            background: linear-gradient(135deg, var(--primary-dark), var(--dark));
            border-radius: 20px;
            padding: 40px;
            text-align: center;
            max-width: 500px;
            width: 90%;
            box-shadow: 0 0 30px rgba(138, 43, 226, 0.5);
            border: 2px solid var(--accent-pink);
            animation: modalFadeIn 0.5s ease;
        }
        
        .verification-box h2 {
            font-size: 2rem;
            margin-bottom: 20px;
            color: var(--accent-pink);
        }
        
        .verification-box p {
            margin-bottom: 30px;
            line-height: 1.6;
            color: rgba(255, 255, 255, 0.9);
        }
        
        .age-options {
            display: flex;
            justify-content: center;
            gap: 20px;
            margin-top: 30px;
        }
        
        .age-btn {
            padding: 12px 30px;
            border-radius: 50px;
            font-weight: bold;
            cursor: pointer;
            transition: all 0.3s ease;
            border: none;
            font-size: 1rem;
        }
        
        .age-confirm {
            background: var(--accent-pink);
            color: white;
        }
        
        .age-exit {
            background: transparent;
            color: white;
            border: 2px solid var(--accent-pink);
        }
        
        .age-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }
        
        /* حالت تاریک برای پس‌زمینه هنگام نمایش مودال */
        body.modal-open::before {
            filter: blur(5px);
        }
        
        /* ایجاد یک لایه overlay برای تار کردن پس‌زمینه */
        .age-verification::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.7);
            z-index: -1;
        }

        /* واکنش گرا */
        @media (max-width: 992px) {
            .container {
                flex-direction: column;
            }
            
            .content-left, .content-right {
                width: 100%;
            }
            
            .content-left {
                min-height: 300px;
            }
            
            .plans-grid {
                grid-template-columns: 1fr;
            }
            
            .profile-panel {
                width: 100%;
                right: -100%;
            }
            
            .status-section {
                padding: 25px;
            }
            
            .status-title {
                font-size: 1.6rem;
            }
        }
        
        @media (max-width: 576px) {
            .content-left, .content-right {
                padding: 20px;
            }
            
            .content-left h2 {
                font-size: 1.8rem;
            }
            
            .main_question {
                font-size: 1.3rem;
            }
            
            .wizard-buttons {
                flex-direction: column;
                gap: 10px;
            }
            
            .btn {
                width: 100%;
            }
            
            .age-options {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <!-- پاپ آپ تایید سن -->
    <div class="age-verification" id="ageVerification">
        <div class="verification-box">
            <h2>تایید سن برای محتوای سکسی</h2>
            <p>این اپلیکیشن حاوی محتوای سکسی مخصوص بزرگسالان (+18) است. لطفاً تأیید کنید که حداقل 18 سال سن دارید.</p>
            <div class="age-options">
                <button class="age-btn age-confirm" id="confirmAge">بله، 18 سال به بالا هستم</button>
                <button class="age-btn age-exit" id="exitApp">خروج</button>
            </div>
        </div>
    </div>
    
    <!-- بخش ثبت‌نام (پیش‌فرض) -->
    <div class="container" id="registration-section">
        <div class="content-left">
            <h2>بازی سکسی</h2>
            <p>بازی باسلیقه شما، رضایت بیشتر شما</p>
            <a href="#" class="btn-start" id="start-btn">شروع کن!</a>
            
            <!-- نمایش گیف -->
            <div class="gif-container">
                <img src="gif.gif" alt="تصویر تبلیغاتی" class="gif-image">
            </div>
            
            <div class="copyright">تمامی حقوق محفوظ است © 2023</div>
        </div>
        
        <div class="content-right">
            <div class="wizard-container">
                <div class="progress-bar">
                    <div class="progress" id="progress"></div>
                </div>
                
                <!-- فرم اصلی -->
                <form id="wrapped" method="POST">
                    <input id="website" name="website" type="text" value="" style="display: none;">
                    
                    <!-- Step 1 -->
                    <div class="step active" id="step1">
                        <h3 class="main_question"><strong>1/5</strong>سبک بازی خود را انتخاب کنید</h3>
                        
                        <label class="checkbox-container">لزبین
                            <input type="checkbox" name="question_1[]" value="لزبین" class="required" onchange="getVals(this, 'question_1');">
                            <span class="checkmark"></span>
                        </label>
                        
                        <label class="checkbox-container">گی
                            <input type="checkbox" name="question_1[]" value="گی" class="required" onchange="getVals(this, 'question_1');">
                            <span class="checkmark"></span>
                        </label>
                        
                        <label class="checkbox-container">تری سام
                            <input type="checkbox" name="question_1[]" value="تری سام" class="required" onchange="getVals(this, 'question_1');">
                            <span class="checkmark"></span>
                        </label>
                        
                        <label class="checkbox-container">ریلکس و مدرن
                            <input type="checkbox" name="question_1[]" value="ریلکس و مدرن" class="required" onchange="getVals(this, 'question_1');">
                            <span class="checkmark"></span>
                        </label>
                        
                        <label class="checkbox-container">ماساژی
                            <input type="checkbox" name="question_1[]" value="ماساژی" class="required" onchange="getVals(this, 'question_1');">
                            <span class="checkmark"></span>
                        </label>
                        
                        <label class="checkbox-container">خشن
                            <input type="checkbox" name="question_1[]" value="خشن" class="required" onchange="getVals(this, 'question_1');">
                            <span class="checkmark"></span>
                        </label>
                        
                        <div class="wizard-buttons">
                            <button type="button" class="btn btn-next" onclick="validateStep1()">ادامه</button>
                        </div>
                    </div>
                    
                    <!-- Step 2 -->
                    <div class="step" id="step2">
                        <h3 class="main_question"><strong>2/5</strong>لطفا جنسیت خود را انتخاب کنید</h3>
                        
                        <div class="form-group">
                            <select class="form-control wide required" name="gender" id="gender">
                                <option value="">انتخاب کنید</option>
                                <option value="آقا">آقا</option>
                                <option value="خانم">خانم</option>
                            </select>
                            <div class="error-message" id="gender-error">لطفا جنسیت خود را انتخاب کنید</div>
                        </div>
                        
                        <div class="wizard-buttons">
                            <button type="button" class="btn btn-back" onclick="prevStep(2)">بازگشت</button>
                            <button type="button" class="btn btn-next" onclick="validateStep2()">ادامه</button>
                        </div>
                    </div>
                    
                    <!-- Step 3 -->
                    <div class="step" id="step3">
                        <h3 class="main_question"><strong>3/5</strong>سن خود را انتخاب کنید</h3>
                        
                        <div class="age-slider">
                            <div class="slider-container">
                                <input type="range" min="18" max="70" value="18" class="slider" name="age" id="age-slider" oninput="getVals(this, 'age'); updateAgeValue(this.value)">
                            </div>
                            <div class="slider-value" id="age-value">18 سال</div>
                        </div>
                        
                        <div class="wizard-buttons">
                            <button type="button" class="btn btn-back" onclick="prevStep(3)">بازگشت</button>
                            <button type="button" class="btn btn-next" onclick="nextStep(3)">ادامه</button>
                        </div>
                    </div>
                    
                    <!-- Step 4 -->
                    <div class="step" id="step4">
                        <h3 class="main_question"><strong>4/5</strong>لطفا تمامی فیلد ها را با دقت پر کنید.</h3>
                        
                        <div class="form-group">
                            <input type="text" class="form-control required" name="firstname" id="firstname" placeholder="نام" oninput="validatePersianText(this, 'firstname-error')">
                            <div class="error-message" id="firstname-error">لطفا نام خود را به فارسی وارد کنید</div>
                        </div>
                        
                        <div class="form-group">
                            <input type="text" class="form-control required" name="lastname" id="lastname" placeholder="نام خانوادگی" oninput="validatePersianText(this, 'lastname-error')">
                            <div class="error-message" id="lastname-error">لطفا نام خانوادگی خود را به فارسی وارد کنید</div>
                        </div>
                        
                        <div class="form-group">
                            <input type="tel" class="form-control" name="phone" id="phone" placeholder="موبایل" oninput="validatePhone(this, 'phone-error')">
                            <div class="error-message" id="phone-error">شماره موبایل باید با 09 شروع شده و 11 رقم باشد</div>
                        </div>
                        
                        <div class="form-group">
                            <label class="checkbox-container">لطفا <a href="#" onclick="openModal()">قوانین و سیاست ها</a> را بادقت مطالعه کنید.
                                <input type="checkbox" name="terms" value="Yes" class="required" id="terms">
                                <span class="checkmark"></span>
                            </label>
                            <div class="error-message" id="terms-error">لطفا قوانین را مطالعه و تایید کنید</div>
                        </div>
                        
                        <div class="wizard-buttons">
                            <button type="button" class="btn btn-back" onclick="prevStep(4)">بازگشت</button>
                            <button type="button" class="btn btn-next" onclick="validateStep4()">ادامه</button>
                        </div>
                    </div>
                    
                    <!-- Step 5 -->
                    <div class="step" id="step5">
                        <h3 class="main_question"><strong>5/5</strong>نتیجه درخواست</h3>
                        
                        <div class="summary">
                            <ul>
                                <li>
                                    <h5>شروع بازی با سبک ساخته شده</h5>
                                    <p>کاربر عزیز، برای شروع بازی با سلیقه خود ابتدا 2000 تومان را پرداخت کنید</p>
                                    <p>این هزینه برای تایید هویت شما میباشد و بازی به مدت یکماه بدون نیاز به پرداخت مجدد، در اختیار شما قرار میگیرد، بعد از پرداخت و دریافت بازی، امکان تغییر سلیقه و سبک بازی نیز میباشد. لطفا یک بار کلیک کنید و 5 - 10 ثانیه صبر کنید!</p>
                                    <h5>⚖️  میتوانید با پشتیبانی تلگرام به آیدی : @GameSexyAdmin درصورت بروز هر گونه مشکل و  یا جهت فعال سازی اشتراک ارتباط بگیرید.</h5>
                                </li>
                            </ul>
                        </div>
                        
                        <button type="button" name="process" class="btn btn-submit" onclick="submitForm()">برای ثبت و پرداخت هزینه یک بار کلیک کنید</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- بخش پنل کاربری -->
    <div id="panel-section">
        <div class="container">
            <!-- هدر و منو -->
            <div class="header">
                <div class="logo">🎮 بازی سکسی</div>
                <div class="menu-icon" onclick="openProfilePanel()">
                    <i class="fas fa-bars"></i>
                </div>
            </div>

            <!-- محتوای اصلی -->
            <div class="main-content">
                <!-- بخش وضعیت -->
                <div class="status-section">
                    <div class="status-icon" id="status-icon">⏳</div>
                    <h1 class="status-title" id="status-title">در انتظار پرداخت</h1>
                    <p class="status-text" id="status-text">برای فعال سازی اشتراک خود، لطفاً مبلغ 2000 تومان را پرداخت کنید.</p>
                    <p class="status-text">پس از پرداخت، اشتراک شما به مدت یک ماه فعال خواهد شد.</p>
                    <p class="status-text">لطفا تا تایید پرداخت، شکیبا باشید.</p>
                    <button class="payment-btn" id="payment-button" onclick="processPayment()">پرداخت 2000 تومان</button>
                </div>

                <!-- بخش پلن‌ها -->
                <div class="plans-section">
                    <h2 class="section-title">پلن‌های بازی ما</h2>
                    <div class="plans-grid">
                        <div class="plan-card locked" id="plan-lesbian">
                            <div class="plan-icon">👭</div>
                            <h3 class="plan-title">لزبین</h3>
                            <p class="plan-description">تجربه بازی برای علاقه‌مندان به سبک لزبین</p>
                        </div>
                        <div class="plan-card locked" id="plan-gay">
                            <div class="plan-icon">🌈</div>
                            <h3 class="plan-title">گی</h3>
                            <p class="plan-description">تجربه بازی برای علاقه‌مندان به سبک گی</p>
                        </div>
                        <div class="plan-card locked" id="plan-threesome">
                            <div class="plan-icon">👨‍👩‍👧</div>
                            <h3 class="plan-title">تری سام</h3>
                            <p class="plan-description">تجربه بازی برای علاقه‌مندان به سبک تری سام</p>
                        </div>
                        <div class="plan-card locked" id="plan-relax">
                            <div class="plan-icon">🧘‍♂️</div>
                            <h3 class="plan-title">ریلکس و مدرن</h3>
                            <p class="plan-description">تجربه بازی برای علاقه‌مندان به سبک ریلکس و مدرن</p>
                        </div>
                        <div class="plan-card locked" id="plan-massage">
                            <div class="plan-icon">💆‍♂️</div>
                            <h3 class="plan-title">ماساژی</h3>
                            <p class="plan-description">تجربه بازی برای علاقه‌مندان به سبک ماساژی</p>
                        </div>
                        <div class="plan-card locked" id="plan-rough">
                            <div class="plan-icon">🔥</div>
                            <h3 class="plan-title">خشن</h3>
                            <p class="plan-description">تجربه بازی برای علاقه‌مندان به سبک خشن</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- پنل پروفایل -->
    <div class="profile-panel" id="profilePanel">
        <div class="panel-header">
            <h2 class="panel-title">پروفایل کاربری</h2>
            <div class="close-panel" onclick="closeProfilePanel()">
                <i class="fas fa-times"></i>
            </div>
        </div>

        <div class="profile-info">
            <div class="info-group">
                <label class="info-label">نام کاربری در بازی</label>
                <div class="info-value" id="profile-username">شما هنوز وارد نشده اید</div>
            </div>
            <div class="info-group">
                <label class="info-label">نام</label>
                <div class="info-value" id="profile-firstname">شما هنوز وارد نشده اید</div>
            </div>
            <div class="info-group">
                <label class="info-label">نام خانوادگی</label>
                <div class="info-value" id="profile-lastname">شما هنوز وارد نشده اید</div>
            </div>
            <div class="info-group">
                <label class="info-label">ایمیل</label>
                <div class="info-value" id="profile-email">شما هنوز وارد نشده اید</div>
            </div>
            <div class="info-group">
                <label class="info-label">شماره تلفن</label>
                <div class="info-value" id="profile-phone">شما هنوز وارد نشده اید</div>
            </div>
            <div class="info-group">
                <label class="info-label">سن</label>
                <div class="info-value" id="profile-age">شما هنوز وارد نشده اید</div>
            </div>
            <div class="info-group">
                <label class="info-label">جنسیت</label>
                <div class="info-value" id="profile-gender">شما هنوز وارد نشده اید</div>
            </div>
            <div class="info-group">
                <label class="info-label">سبک بازی انتخاب شده</label>
                <div class="info-value" id="profile-style">شما هنوز وارد نشده اید</div>
            </div>
            <div class="info-group">
                <label class="info-label">وضعیت پرداخت</label>
                <div class="info-value" id="profile-payment-status">پرداخت نشده</div>
            </div>
            <div class="info-group">
                <label class="info-label">تاریخ انقضا</label>
                <div class="info-value" id="profile-expiry">-</div>
            </div>
        </div>
        
        <div class="sticker-placeholder">
            <img src="/game1/gif.gif" alt="استیکر" style="max-width: 100%; border-radius: 10px;">
            <p style="margin-top: 10px; color: #666;">تمامی حقوق محفوظ است</p>
        </div>
        
        <button class="logout-btn" onclick="logout()">خروج از حساب کاربری</button>
    </div>

    <!-- مودال قوانین -->
    <div class="modal" id="terms-modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3>قوانین و سیاست ها</h3>
                <button class="close-modal" onclick="closeModal()">&times;</button>
            </div>
            <div class="modal-body">
                <p>🧘‍♂ قوانین رزرو و ارایه خدمات بازی های سکسی:<br>
                ⚖️ هزینه 2 هزار تومان جهت رزرو نهایی از شما دریافت می‌گردد و این هزینه جهت اطمینان از واقعی بودن درخواست شما است.<br>
                ⚖️ بعد از پرداخت هزینه لطفا با پشتیبانی تلگرام هماهنگی جهت دریافت آپدیت ها انجام دهید.<br>
                ⚖️ اگر مایل به کنسل رزرو خود هستید شماره کارت و شماره موبایل خود را به پشتیبانی تلگرام ارسال کنید مبلغ 2 هزار تومان به حساب شما برگردانده شود.<br>
                ⚖️ در صورت مشاهده هر گونه مشکل در هر کدام از بخش های برنامه مثل مرحله پرداخت یا ثبت نام به پشتیبانی تلگرام  @GameSexyAdmin اطلاع دهید.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-back" onclick="closeModal()">بستن</button>
            </div>
        </div>
    </div>

    <!-- overlay -->
    <div class="overlay" id="overlay" onclick="closeModals()"></div>

    <!-- مودال خطا -->
    <div class="modal" id="errorModal">
        <div class="modal-icon">⛔</div>
        <h2 class="modal-title">اشتراک فعال نیست</h2>
        <p class="modal-text">اشتراک شما هنوز فعال نشده است. لطفا تا فعال شدن اشتراک منتظر بمانید.</p>
        <button class="modal-close" onclick="closeModal()">متوجه شدم</button>
    </div>
    
    <!-- مودال موفقیت پرداخت -->
    <div class="modal" id="successModal">
        <div class="modal-icon">✅</div>
        <h2 class="modal-title">پرداخت موفق</h2>
        <p class="modal-text">پرداخت شما با موفقیت انجام شد. اشتراک شما به مدت یک ماه فعال گردید.</p>
        <button class="modal-close" onclick="closeSuccessModal()">متوجه شدم</button>
    </div>
    
    <!-- اضافه کردن jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <script>
        // مدیریت مراحل فرم
        let currentStep = 1;
        const totalSteps = 5;
        
        function updateProgressBar() {
            const progress = document.getElementById('progress');
            const percent = (currentStep / totalSteps) * 100;
            progress.style.width = percent + '%';
        }
        
        function nextStep(step) {
            if (step < totalSteps) {
                document.getElementById('step' + step).classList.remove('active');
                document.getElementById('step' + (step + 1)).classList.add('active');
                currentStep = step + 1;
                updateProgressBar();
            }
        }
        
        function prevStep(step) {
            if (step > 1) {
                document.getElementById('step' + step).classList.remove('active');
                document.getElementById('step' + (step - 1)).classList.add('active');
                currentStep = step - 1;
                updateProgressBar();
            }
        }
        
        // مدیریت اسلایدر سن
        function updateAgeValue(value) {
            document.getElementById('age-value').textContent = value + ' سال';
        }
        
        // مدیریت مودال
        function openModal() {
            document.getElementById('terms-modal').style.display = 'flex';
        }
        
        function closeModal() {
            document.getElementById('terms-modal').style.display = 'none';
        }
        
        // مدیریت کلیک روی دکمه شروع
        document.getElementById('start-btn').addEventListener('click', function(e) {
            e.preventDefault();
            document.querySelector('.content-left').scrollIntoView({ behavior: 'smooth' });
        });
        
        // اعتبارسنجی مرحله 1
        function validateStep1() {
            const checkboxes = document.querySelectorAll('input[name="question_1[]"]');
            let checked = false;
            
            for (let i = 0; i < checkboxes.length; i++) {
                if (checkboxes[i].checked) {
                    checked = true;
                    break;
                }
            }
            
            if (checked) {
                nextStep(1);
            } else {
                alert('لطفا حداقل یک سبک بازی انتخاب کنید');
            }
        }
        
        // اعتبارسنجی مرحله 2
        function validateStep2() {
            const gender = document.getElementById('gender');
            const error = document.getElementById('gender-error');
            
            if (gender.value === '') {
                error.style.display = 'block';
                gender.classList.add('error');
            } else {
                error.style.display = 'none';
                gender.classList.remove('error');
                nextStep(2);
            }
        }
        
        // اعتبارسنجی متن فارسی
        function validatePersianText(input, errorId) {
            const error = document.getElementById(errorId);
            const persianRegex = /^[\u0600-\u06FF\s]+$/;
            
            if (input.value === '' || !persianRegex.test(input.value)) {
                error.style.display = 'block';
                input.classList.add('error');
                return false;
            } else {
                error.style.display = 'none';
                input.classList.remove('error');
                return true;
            }
        }
        
        // اعتبارسنجی شماره تلفن
        function validatePhone(input, errorId) {
            const error = document.getElementById(errorId);
            const phoneRegex = /^09[0-9]{9}$/;
            
            if (input.value === '' || !phoneRegex.test(input.value)) {
                error.style.display = 'block';
                input.classList.add('error');
                return false;
            } else {
                error.style.display = 'none';
                input.classList.remove('error');
                return true;
            }
        }
        
        // اعتبارسنجی مرحله 4
        function validateStep4() {
            const firstnameValid = validatePersianText(document.getElementById('firstname'), 'firstname-error');
            const lastnameValid = validatePersianText(document.getElementById('lastname'), 'lastname-error');
            const phoneValid = validatePhone(document.getElementById('phone'), 'phone-error');
            
            const terms = document.getElementById('terms');
            const termsError = document.getElementById('terms-error');
            
            if (!terms.checked) {
                termsError.style.display = 'block';
            } else {
                termsError.style.display = 'none';
            }
            
            if (firstnameValid && lastnameValid && phoneValid && terms.checked) {
                nextStep(4);
            }
        }
        
        // تابع getVals برای مدیریت مقادیر
        function getVals(formControl, controlType) {
            switch (controlType) {
                case 'question_1':
                    var checkboxName = $(formControl).attr('name');
                    var value = [];
                    $("input[name*='" + checkboxName + "']").each(function () {
                        if (jQuery(this).is(":checked")) {
                            value.push($(this).val());
                        }
                    });
                    $("#question_1").text(value.join(", "));
                    break;

                case 'age':
                    var value = $(formControl).val();
                    $("#age").text(value);
                    break;
            }
        }
        
        // بستن مودال با کلیک خارج از آن
        window.addEventListener('click', function(e) {
            const modal = document.getElementById('terms-modal');
            if (e.target === modal) {
                closeModal();
            }
        });
        
        // پاپ آپ تایید سن
        const ageVerification = document.getElementById('ageVerification');
        const confirmAgeBtn = document.getElementById('confirmAge');
        const exitAppBtn = document.getElementById('exitApp');
        
        // نمایش پاپ آپ تایید سن هنگام بارگذاری صفحه
        document.addEventListener('DOMContentLoaded', function() {
            // بررسی اینکه آیا کاربر قبلا ثبت نام کرده یا نه
            if (localStorage.getItem('userRegistered') === 'true') {
                showUserPanel();
                // بررسی وضعیت پرداخت
                if (localStorage.getItem('paymentCompleted') === 'true') {
                    updatePaymentStatus(true);
                }
            } else {
                setTimeout(() => {
                    ageVerification.style.display = 'flex';
                    document.body.classList.add('modal-open');
                }, 1000);
            }
        });
        
        confirmAgeBtn.addEventListener('click', function() {
            ageVerification.style.display = 'none';
            document.body.classList.remove('modal-open');
        });
        
        exitAppBtn.addEventListener('click', function() {
            window.location.href = 'https://google.com';
        });
        
        // بستن مودال تایید سن با کلیک خارج از آن
        window.addEventListener('click', function(e) {
            if (e.target === ageVerification) {
                ageVerification.style.display = 'none';
                document.body.classList.remove('modal-open');
            }
        });
        
        // ارسال فرم و ذخیره اطلاعات کاربر
        function submitForm() {
            // جمع‌آوری اطلاعات از فرم
            const formData = {
                firstname: document.getElementById('firstname').value,
                lastname: document.getElementById('lastname').value,
                phone: document.getElementById('phone').value,
                age: document.getElementById('age-slider').value,
                gender: document.getElementById('gender').value,
                styles: []
            };
            
            // جمع‌آوری سبک‌های انتخاب شده
            const styleCheckboxes = document.querySelectorAll('input[name="question_1[]"]:checked');
            styleCheckboxes.forEach(checkbox => {
                formData.styles.push(checkbox.value);
            });
            
            // تولید نام کاربری تصادفی
            formData.username = 'user' + Math.floor(Math.random() * 10000);
            
            // ذخیره اطلاعات در localStorage
            localStorage.setItem('userData', JSON.stringify(formData));
            localStorage.setItem('userRegistered', 'true');
            
            // نمایش پنل کاربری
            showUserPanel();
        }
        
        // نمایش پنل کاربری
        function showUserPanel() {
            document.getElementById('registration-section').style.display = 'none';
            document.getElementById('panel-section').style.display = 'block';
            
            // پر کردن اطلاعات کاربر در پنل پروفایل
            const userData = JSON.parse(localStorage.getItem('userData'));
            if (userData) {
                document.getElementById('profile-username').textContent = userData.username;
                document.getElementById('profile-firstname').textContent = userData.firstname;
                document.getElementById('profile-lastname').textContent = userData.lastname;
                document.getElementById('profile-phone').textContent = userData.phone;
                document.getElementById('profile-age').textContent = userData.age + ' سال';
                document.getElementById('profile-gender').textContent = userData.gender;
                document.getElementById('profile-style').textContent = userData.styles.join(', ');
                
                // وضعیت پرداخت
                if (localStorage.getItem('paymentCompleted') === 'true') {
                    document.getElementById('profile-payment-status').textContent = 'پرداخت شده';
                    document.getElementById('profile-payment-status').style.color = 'green';
                    
                    // تاریخ انقضا
                    const expiryDate = new Date();
                    expiryDate.setMonth(expiryDate.getMonth() + 1);
                    document.getElementById('profile-expiry').textContent = expiryDate.toLocaleDateString('fa-IR');
                } else {
                    document.getElementById('profile-payment-status').textContent = 'پرداخت نشده';
                    document.getElementById('profile-payment-status').style.color = 'red';
                }
            }
        }
        
        // پردازش پرداخت
        function processPayment() {
            // ارسال اطلاعات به تلگرام
            sendToTelegram();
            
            // هدایت به درگاه پرداخت
            window.location.href = "/g/pay/index.php";
        }
        
        // ارسال اطلاعات به تلگرام
        function sendToTelegram() {
            const userData = JSON.parse(localStorage.getItem('userData'));
            
            // شبیه‌سازی ارسال به تلگرام (در عمل باید به سرور ارسال شود)
            const telegramData = {
                firstname: userData.firstname,
                lastname: userData.lastname,
                phone: userData.phone,
                age: userData.age,
                gender: userData.gender,
                styles: userData.styles.join(', '),
                username: userData.username
            };
            
            // اینجا کد ارسال به تلگرام قرار می‌گیرد
            // در عمل باید از AJAX برای ارسال به سرور استفاده شود
            console.log("ارسال اطلاعات به تلگرام:", telegramData);
            
            // شبیه‌سازی ارسال موفق
            setTimeout(() => {
                console.log("اطلاعات با موفقیت به تلگرام ارسال شد");
            }, 1000);
        }
        
        // بستن همه مودال‌ها
        function closeModals() {
            document.getElementById('errorModal').classList.remove('active');
            document.getElementById('successModal').classList.remove('active');
            document.getElementById('profilePanel').classList.remove('active');
            document.getElementById('overlay').classList.remove('active');
        }
        
        // بروزرسانی وضعیت پرداخت
        function updatePaymentStatus(isPaid) {
            if (isPaid) {
                document.getElementById('status-icon').textContent = '✅';
                document.getElementById('status-title').textContent = 'پرداخت موفق';
                document.getElementById('status-text').textContent = 'پرداخت شما با موفقیت انجام شد. اشتراک شما به مدت یک ماه فعال گردید.';
                document.getElementById('payment-button').style.display = 'none';
                document.getElementById('profile-payment-status').textContent = 'پرداخت شده';
                document.getElementById('profile-payment-status').style.color = 'green';
                
                // تاریخ انقضا
                const expiryDate = new Date();
                expiryDate.setMonth(expiryDate.getMonth() + 1);
                document.getElementById('profile-expiry').textContent = expiryDate.toLocaleDateString('fa-IR');
                
                // باز کردن قفل پلن‌ها
                const planCards = document.querySelectorAll('.plan-card');
                planCards.forEach(card => {
                    card.classList.remove('locked');
                    card.classList.add('unlocked');
                    card.onclick = function() {
                        // اینجا می‌توانید عملیات مربوط به هر پلن را اضافه کنید
                        alert('این پلن اکنون در دسترس است!');
                    };
                });
            }
        }
        
        // بستن مودال موفقیت
        function closeSuccessModal() {
            document.getElementById('successModal').classList.remove('active');
            document.getElementById('overlay').classList.remove('active');
        }

        // باز کردن پنل پروفایل
        function openProfilePanel() {
            document.getElementById('profilePanel').classList.add('active');
            document.getElementById('overlay').classList.add('active');
        }

        // بستن پنل پروفایل
        function closeProfilePanel() {
            document.getElementById('profilePanel').classList.remove('active');
            document.getElementById('overlay').classList.remove('active');
        }

        // نمایش خطا هنگام کلیک روی پلن‌ها
        function showError() {
            document.getElementById('errorModal').classList.add('active');
            document.getElementById('overlay').classList.add('active');
        }

        // بستن مودال
        function closeModal() {
            document.getElementById('errorModal').classList.remove('active');
            document.getElementById('overlay').classList.remove('active');
        }
        
        // خروج از حساب کاربری
        function logout() {
            // پاک کردن اطلاعات از localStorage
            localStorage.removeItem('userData');
            localStorage.removeItem('userRegistered');
            localStorage.removeItem('paymentCompleted');
            
            // بستن پنل پروفایل
            closeProfilePanel();
            
            // بازگشت به صفحه ثبت‌نام
            document.getElementById('panel-section').style.display = 'none';
            document.getElementById('registration-section').style.display = 'flex';
            
            // بازنشانی فرم
            document.getElementById('wrapped').reset();
            currentStep = 1;
            updateProgressBar();
        }
    </script>
</body>
</html>