<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Telbet - پلتفرم بازی و سرگرمی</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        /* Reset and Base Styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Poppins', sans-serif;
        }

        body {
            width: 100%;
            min-height: 100%;
            background: linear-gradient(180deg, #030730 0%, #12154c 100%);
            color: #ffffff;
            overflow-x: hidden;
            position: relative;
            transition: all 0.3s ease;
        }

        body[dir="ltr"] {
            text-align: left;
        }

        body[dir="rtl"] {
            text-align: right;
        }

        /* Starry Background */
        .stars {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
            z-index: 0;
        }

        .star {
            position: absolute;
            background: white;
            border-radius: 50%;
            animation: twinkle 3s infinite;
        }

        @keyframes twinkle {
            0%, 100% { opacity: 0.3; }
            50% { opacity: 1; }
        }

        /* Blob Clouds */
        .blob {
            position: fixed;
            border-radius: 50%;
            filter: blur(80px);
            opacity: 0.15;
            pointer-events: none;
            z-index: 0;
        }

        .blob-1 {
            width: 500px;
            height: 500px;
            background: radial-gradient(circle, #2433d7 0%, transparent 70%);
            top: -100px;
            right: -100px;
            animation: float 20s infinite ease-in-out;
        }

        .blob-2 {
            width: 600px;
            height: 600px;
            background: radial-gradient(circle, #a96aca 0%, transparent 70%);
            bottom: -150px;
            left: -150px;
            animation: float 25s infinite ease-in-out reverse;
        }

        .blob-3 {
            width: 400px;
            height: 400px;
            background: radial-gradient(circle, #08c6aa 0%, transparent 70%);
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            animation: float 30s infinite ease-in-out;
        }

        @keyframes float {
            0%, 100% { transform: translate(0, 0) scale(1); }
            33% { transform: translate(50px, -50px) scale(1.1); }
            66% { transform: translate(-30px, 30px) scale(0.9); }
        }

        /* Header */
        header {
            position: sticky;
            top: 0;
            width: 100%;
            background: rgba(3, 7, 48, 0.8);
            backdrop-filter: blur(20px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            padding: 16px 40px;
            z-index: 1000;
            transition: all 0.3s ease;
        }

        .header-content {
            max-width: 1400px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        body[dir="ltr"] .header-content {
            flex-direction: row;
        }

        body[dir="rtl"] .header-content {
            flex-direction: row-reverse;
        }

        .logo-section {
            display: flex;
            align-items: center;
            gap: 12px;
            cursor: pointer;
        }

        .mascot-logo {
            width: 48px;
            height: 48px;
            background: linear-gradient(135deg, #08c6aa 0%, #01aba5 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 4px 20px rgba(8, 198, 170, 0.4);
            position: relative;
            overflow: hidden;
        }

        .mascot-face {
            font-size: 28px;
            position: relative;
            z-index: 2;
        }

        .mascot-glow {
            position: absolute;
            width: 100%;
            height: 100%;
            background: radial-gradient(circle, rgba(255, 255, 255, 0.3) 0%, transparent 70%);
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0%, 100% { transform: scale(1); opacity: 0.5; }
            50% { transform: scale(1.2); opacity: 0.8; }
        }

        .brand-text h1 {
            font-size: 24px;
            font-weight: 700;
            background: linear-gradient(135deg, #08c6aa 0%, #ffffff 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin: 0;
        }

        .brand-text p {
            font-size: 11px;
            color: #d5d8e6;
            font-weight: 400;
            margin: 0;
        }

        nav {
            display: flex;
            align-items: center;
            gap: 32px;
        }

        .nav-links {
            display: flex;
            gap: 28px;
            list-style: none;
        }

        body[dir="ltr"] .nav-links {
            flex-direction: row;
        }

        body[dir="rtl"] .nav-links {
            flex-direction: row-reverse;
        }

        .nav-links a {
            color: #d5d8e6;
            text-decoration: none;
            font-size: 15px;
            font-weight: 500;
            transition: all 0.3s ease;
            position: relative;
            cursor: pointer;
        }

        .nav-links a:hover {
            color: #08c6aa;
        }

        .nav-links a.active::after {
            content: '';
            position: absolute;
            bottom: -8px;
            left: 0;
            width: 100%;
            height: 2px;
            background: linear-gradient(90deg, #08c6aa 0%, #01aba5 100%);
            border-radius: 2px;
        }

        .auth-buttons {
            display: flex;
            gap: 12px;
        }

        body[dir="ltr"] .auth-buttons {
            flex-direction: row;
        }

        body[dir="rtl"] .auth-buttons {
            flex-direction: row-reverse;
        }

        .user-profile {
            position: relative;
            display: none;
        }

        .user-profile.active {
            display: block;
        }

        .profile-avatar {
            width: 48px;
            height: 48px;
            background: linear-gradient(135deg, #08c6aa 0%, #01aba5 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            cursor: pointer;
            box-shadow: 0 4px 20px rgba(8, 198, 170, 0.4);
            border: 2px solid rgba(255, 255, 255, 0.2);
            transition: all 0.3s ease;
        }

        .profile-avatar:hover {
            transform: scale(1.05);
            box-shadow: 0 6px 28px rgba(8, 198, 170, 0.6);
        }

        .profile-dropdown {
            position: absolute;
            top: 60px;
            background: linear-gradient(135deg, #15194d 0%, #11153c 100%);
            border-radius: 16px;
            padding: 16px;
            min-width: 280px;
            box-shadow: 0 24px 60px rgba(0, 0, 0, 0.6);
            border: 1px solid rgba(255, 255, 255, 0.1);
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
            transition: all 0.3s ease;
        }

        body[dir="ltr"] .profile-dropdown {
            right: 0;
        }

        body[dir="rtl"] .profile-dropdown {
            left: 0;
        }

        .profile-dropdown.show {
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        .profile-info {
            padding: 12px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            margin-bottom: 12px;
        }

        .profile-name {
            font-size: 16px;
            font-weight: 600;
            margin-bottom: 4px;
        }

        .profile-email {
            font-size: 13px;
            color: #d5d8e6;
        }

        .profile-balance {
            background: rgba(8, 198, 170, 0.15);
            padding: 12px;
            border-radius: 12px;
            margin-bottom: 12px;
            text-align: center;
        }

        .balance-label {
            font-size: 12px;
            color: #d5d8e6;
            margin-bottom: 4px;
        }

        .balance-amount {
            font-size: 24px;
            font-weight: 700;
            color: #08c6aa;
        }

        .profile-menu {
            list-style: none;
        }

        .profile-menu li {
            padding: 10px 12px;
            border-radius: 8px;
            cursor: pointer;
            transition: all 0.2s ease;
            display: flex;
            align-items: center;
            gap: 12px;
            font-size: 14px;
        }

        body[dir="ltr"] .profile-menu li {
            flex-direction: row;
        }

        body[dir="rtl"] .profile-menu li {
            flex-direction: row-reverse;
        }

        .profile-menu li:hover {
            background: rgba(8, 198, 170, 0.1);
            color: #08c6aa;
        }

        .profile-menu li.logout {
            color: #f52cc1;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            margin-top: 8px;
            padding-top: 16px;
        }

        .profile-menu li.logout:hover {
            background: rgba(245, 44, 193, 0.1);
        }

        /* Language Switcher */
        .language-switcher {
            display: flex;
            gap: 4px;
            margin: 0 20px;
        }

        .lang-btn {
            padding: 6px 12px;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 8px;
            color: #d5d8e6;
            font-size: 12px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .lang-btn.active {
            background: linear-gradient(135deg, #08c6aa 0%, #01aba5 100%);
            border-color: #08c6aa;
            color: white;
        }

        .lang-btn:hover:not(.active) {
            background: rgba(255, 255, 255, 0.2);
        }

        .btn-secondary {
            padding: 10px 24px;
            background: transparent;
            border: 1.5px solid #262a5d;
            border-radius: 9999px;
            color: #ffffff;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .btn-secondary:hover {
            border-color: #08c6aa;
            color: #08c6aa;
            transform: translateY(-1px);
        }

        .btn-primary {
            padding: 12px 28px;
            background: linear-gradient(135deg, #08c6aa 0%, #01aba5 100%);
            border: none;
            border-radius: 9999px;
            color: #ffffff;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            box-shadow: 0 8px 24px rgba(8, 198, 170, 0.4);
            transition: all 0.3s ease;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 12px 32px rgba(8, 198, 170, 0.5);
            background: linear-gradient(135deg, #0adec0 0%, #02c4b8 100%);
        }

        .mobile-menu-toggle {
            display: none;
            background: transparent;
            border: none;
            color: white;
            font-size: 24px;
            cursor: pointer;
        }

        /* Main Container */
        main {
            position: relative;
            z-index: 1;
            max-width: 1400px;
            margin: 0 auto;
            padding: 60px 40px;
        }

        /* Page Content */
        .page-content {
            display: none;
        }

        .page-content.active {
            display: block;
            animation: fadeIn 0.4s ease;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* Hero Card */
        .hero-card {
            background: linear-gradient(135deg, #15194d 0%, #11153c 100%);
            border-radius: 24px;
            box-shadow: 0 24px 60px rgba(0, 0, 0, 0.6);
            padding: 60px;
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 60px;
            align-items: center;
            position: relative;
            overflow: hidden;
            border: 1px solid rgba(255, 255, 255, 0.05);
        }

        .hero-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: radial-gradient(circle at top right, rgba(8, 198, 170, 0.1) 0%, transparent 50%);
            pointer-events: none;
        }

        .hero-content {
            position: relative;
            z-index: 2;
        }

        .welcome-label {
            display: inline-block;
            padding: 8px 20px;
            background: rgba(8, 198, 170, 0.15);
            border: 1px solid rgba(8, 198, 170, 0.3);
            border-radius: 9999px;
            color: #08c6aa;
            font-size: 13px;
            font-weight: 500;
            margin-bottom: 24px;
        }

        .hero-headline {
            font-size: 52px;
            font-weight: 800;
            line-height: 1.2;
            margin-bottom: 20px;
            color: #ffffff;
        }

        .hero-headline .highlight {
            background: linear-gradient(135deg, #08c6aa 0%, #01aba5 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .hero-description {
            font-size: 17px;
            line-height: 1.7;
            color: #d5d8e6;
            margin-bottom: 32px;
            font-weight: 400;
        }

        .hero-cta {
            display: flex;
            gap: 16px;
            flex-wrap: wrap;
        }

        body[dir="ltr"] .hero-cta {
            flex-direction: row;
        }

        body[dir="rtl"] .hero-cta {
            flex-direction: row-reverse;
        }

        .btn-large {
            padding: 16px 40px;
            font-size: 16px;
            font-weight: 600;
        }

        .btn-secondary-large {
            padding: 16px 36px;
            background: rgba(253, 211, 3, 0.15);
            border: 1.5px solid rgba(253, 211, 3, 0.4);
            border-radius: 9999px;
            color: #fdd303;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .btn-secondary-large:hover {
            background: rgba(253, 211, 3, 0.25);
            border-color: #fdd303;
            transform: translateY(-2px);
        }

        /* Hero Visual */
        .hero-visual {
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .visual-container {
            position: relative;
            width: 100%;
            max-width: 500px;
            aspect-ratio: 1;
        }

        .central-mascot {
            width: 240px;
            height: 240px;
            background: linear-gradient(135deg, #08c6aa 0%, #01aba5 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 120px;
            box-shadow: 0 20px 60px rgba(8, 198, 170, 0.5);
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 3;
            animation: mascotFloat 4s infinite ease-in-out;
        }

        @keyframes mascotFloat {
            0%, 100% { transform: translate(-50%, -50%) translateY(0px); }
            50% { transform: translate(-50%, -50%) translateY(-15px); }
        }

        .orbit-icon {
            position: absolute;
            width: 80px;
            height: 80px;
            background: #15194d;
            border: 2px solid rgba(255, 255, 255, 0.1);
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 36px;
            box-shadow: 0 12px 32px rgba(0, 0, 0, 0.4);
            animation: orbit 20s linear infinite;
        }

        .orbit-icon:nth-child(1) {
            top: 10%;
            left: 10%;
            animation-delay: 0s;
        }

        .orbit-icon:nth-child(2) {
            top: 10%;
            right: 10%;
            animation-delay: -5s;
        }

        .orbit-icon:nth-child(3) {
            bottom: 10%;
            left: 10%;
            animation-delay: -10s;
        }

        .orbit-icon:nth-child(4) {
            bottom: 10%;
            right: 10%;
            animation-delay: -15s;
        }

        @keyframes orbit {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            25% { transform: translateY(-20px) rotate(5deg); }
            50% { transform: translateY(0px) rotate(0deg); }
            75% { transform: translateY(20px) rotate(-5deg); }
        }

        /* Auth Modal */
        .modal-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.8);
            backdrop-filter: blur(10px);
            z-index: 9999;
            display: none;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .modal-overlay.show {
            display: flex;
            animation: fadeIn 0.3s ease;
        }

        .auth-modal {
            background: linear-gradient(135deg, #15194d 0%, #11153c 100%);
            border-radius: 24px;
            padding: 48px;
            max-width: 480px;
            width: 100%;
            box-shadow: 0 24px 60px rgba(0, 0, 0, 0.8);
            border: 1px solid rgba(255, 255, 255, 0.1);
            position: relative;
            animation: slideUp 0.4s ease;
        }

        @keyframes slideUp {
            from { transform: translateY(50px); opacity: 0; }
            to { transform: translateY(0); opacity: 1; }
        }

        .modal-close {
            position: absolute;
            top: 20px;
            right: 20px;
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.05);
            border: none;
            border-radius: 50%;
            color: #d5d8e6;
            font-size: 20px;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .modal-close:hover {
            background: rgba(245, 44, 193, 0.2);
            color: #f52cc1;
            transform: rotate(90deg);
        }

        .auth-header {
            text-align: center;
            margin-bottom: 32px;
        }

        .auth-title {
            font-size: 32px;
            font-weight: 700;
            margin-bottom: 8px;
        }

        .auth-subtitle {
            font-size: 15px;
            color: #d5d8e6;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            display: block;
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 8px;
            color: #d5d8e6;
        }

        .form-input {
            width: 100%;
            padding: 14px 20px;
            background: #11153c;
            border: 1.5px solid #262a5d;
            border-radius: 16px;
            color: #ffffff;
            font-size: 15px;
            outline: none;
            transition: all 0.3s ease;
        }

        .form-input::placeholder {
            color: #6b7092;
        }

        .form-input:focus {
            border-color: #08c6aa;
            background: #15194d;
            box-shadow: 0 0 0 4px rgba(8, 198, 170, 0.1);
        }

        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 16px;
        }

        .form-checkbox {
            display: flex;
            align-items: center;
            gap: 8px;
            margin: 20px 0;
        }

        body[dir="ltr"] .form-checkbox {
            flex-direction: row;
        }

        body[dir="rtl"] .form-checkbox {
            flex-direction: row-reverse;
        }

        .form-checkbox input {
            width: 20px;
            height: 20px;
            cursor: pointer;
        }

        .form-checkbox label {
            font-size: 14px;
            color: #d5d8e6;
            cursor: pointer;
        }

        .auth-submit {
            width: 100%;
            padding: 16px;
            background: linear-gradient(135deg, #08c6aa 0%, #01aba5 100%);
            border: none;
            border-radius: 9999px;
            color: #ffffff;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            box-shadow: 0 8px 24px rgba(8, 198, 170, 0.4);
            transition: all 0.3s ease;
            margin-top: 8px;
        }

        .auth-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 12px 32px rgba(8, 198, 170, 0.5);
        }

        .auth-divider {
            text-align: center;
            margin: 24px 0;
            position: relative;
        }

        .auth-divider::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 0;
            width: 100%;
            height: 1px;
            background: rgba(255, 255, 255, 0.1);
        }

        .auth-divider span {
            background: #11153c;
            padding: 0 16px;
            position: relative;
            font-size: 14px;
            color: #6b7092;
        }

        .social-auth {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 12px;
        }

        .social-btn {
            padding: 12px;
            background: rgba(255, 255, 255, 0.05);
            border: 1.5px solid rgba(255, 255, 255, 0.1);
            border-radius: 12px;
            color: #ffffff;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        .social-btn:hover {
            background: rgba(255, 255, 255, 0.1);
            border-color: rgba(255, 255, 255, 0.2);
            transform: translateY(-1px);
        }

        .auth-footer {
            text-align: center;
            margin-top: 24px;
            font-size: 14px;
            color: #d5d8e6;
        }

        .auth-footer a {
            color: #08c6aa;
            text-decoration: none;
            font-weight: 500;
            cursor: pointer;
        }

        .auth-footer a:hover {
            text-decoration: underline;
        }

        /* Games Grid */
        .games-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 24px;
            margin-top: 32px;
        }

        .game-card {
            background: linear-gradient(135deg, #15194d 0%, #11153c 100%);
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 12px 32px rgba(0, 0, 0, 0.4);
            border: 1px solid rgba(255, 255, 255, 0.05);
            transition: all 0.4s ease;
            cursor: pointer;
        }

        .game-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 20px 48px rgba(0, 0, 0, 0.6);
            border-color: rgba(8, 198, 170, 0.3);
        }

        .game-thumbnail {
            width: 100%;
            height: 200px;
            background: linear-gradient(135deg, #2433d7 0%, #1850dc 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 64px;
            position: relative;
            overflow: hidden;
        }

        .game-thumbnail::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: left 0.5s ease;
        }

        .game-card:hover .game-thumbnail::before {
            left: 100%;
        }

        .game-info {
            padding: 20px;
        }

        .game-title {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 8px;
        }

        .game-category {
            display: inline-block;
            padding: 4px 12px;
            background: rgba(8, 198, 170, 0.15);
            border-radius: 9999px;
            font-size: 12px;
            color: #08c6aa;
            margin-bottom: 12px;
        }

        .game-stats {
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 13px;
            color: #d5d8e6;
        }

        .game-rating {
            display: flex;
            align-items: center;
            gap: 4px;
        }

        /* Page Header */
        .page-header {
            margin-bottom: 48px;
            text-align: center;
        }

        .page-title {
            font-size: 48px;
            font-weight: 700;
            margin-bottom: 16px;
        }

        .page-subtitle {
            font-size: 18px;
            color: #d5d8e6;
        }

        /* Feature Cards Section */
        .features-section {
            margin-top: 80px;
        }

        .section-header {
            text-align: center;
            margin-bottom: 48px;
        }

        .section-title {
            font-size: 42px;
            font-weight: 700;
            margin-bottom: 16px;
        }

        .section-subtitle {
            font-size: 18px;
            color: #d5d8e6;
            font-weight: 400;
        }

        .features-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
            gap: 32px;
        }

        .feature-card {
            background: linear-gradient(135deg, #15194d 0%, #11153c 100%);
            border-radius: 24px;
            padding: 40px 32px;
            box-shadow: 0 24px 60px rgba(0, 0, 0, 0.5);
            border: 1px solid rgba(255, 255, 255, 0.05);
            transition: all 0.4s ease;
            cursor: pointer;
        }

        .feature-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 32px 80px rgba(0, 0, 0, 0.6);
            border-color: rgba(8, 198, 170, 0.3);
        }

        .feature-icon {
            width: 72px;
            height: 72px;
            background: rgba(8, 198, 170, 0.15);
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 36px;
            margin-bottom: 24px;
        }

        .feature-card:nth-child(2) .feature-icon {
            background: rgba(253, 211, 3, 0.15);
        }

        .feature-card:nth-child(3) .feature-icon {
            background: rgba(169, 106, 202, 0.15);
        }

        .feature-card:nth-child(4) .feature-icon {
            background: rgba(245, 44, 193, 0.15);
        }

        .feature-title {
            font-size: 24px;
            font-weight: 600;
            margin-bottom: 12px;
        }

        .feature-description {
            font-size: 15px;
            line-height: 1.6;
            color: #d5d8e6;
            margin-bottom: 24px;
        }

        .feature-link {
            color: #08c6aa;
            font-size: 15px;
            font-weight: 500;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            transition: all 0.3s ease;
        }

        body[dir="ltr"] .feature-link:hover {
            gap: 12px;
        }

        body[dir="rtl"] .feature-link:hover {
            gap: 12px;
        }

        /* Category Tabs */
        .category-tabs {
            display: flex;
            gap: 12px;
            margin-bottom: 32px;
            flex-wrap: wrap;
        }

        body[dir="ltr"] .category-tabs {
            flex-direction: row;
        }

        body[dir="rtl"] .category-tabs {
            flex-direction: row-reverse;
        }

        .category-tab {
            padding: 12px 24px;
            background: rgba(255, 255, 255, 0.05);
            border: 1.5px solid rgba(255, 255, 255, 0.1);
            border-radius: 9999px;
            color: #d5d8e6;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .category-tab:hover,
        .category-tab.active {
            background: linear-gradient(135deg, #08c6aa 0%, #01aba5 100%);
            border-color: #08c6aa;
            color: #ffffff;
            transform: translateY(-2px);
        }

        /* Support Page */
        .faq-grid {
            display: grid;
            gap: 16px;
            margin-top: 32px;
        }

        .faq-item {
            background: linear-gradient(135deg, #15194d 0%, #11153c 100%);
            border-radius: 16px;
            padding: 24px;
            border: 1px solid rgba(255, 255, 255, 0.05);
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .faq-item:hover {
            border-color: rgba(8, 198, 170, 0.3);
        }

        .faq-question {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 4px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .faq-answer {
            font-size: 15px;
            color: #d5d8e6;
            line-height: 1.6;
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.3s ease;
            margin-top: 12px;
        }

        .faq-item.open .faq-answer {
            max-height: 200px;
        }

        .faq-item.open .faq-icon {
            transform: rotate(180deg);
        }

        .faq-icon {
            transition: transform 0.3s ease;
        }

        /* Contact Form */
        .contact-form {
            background: linear-gradient(135deg, #15194d 0%, #11153c 100%);
            border-radius: 24px;
            padding: 40px;
            border: 1px solid rgba(255, 255, 255, 0.05);
            box-shadow: 0 24px 60px rgba(0, 0, 0, 0.5);
            max-width: 600px;
            margin: 32px auto 0;
        }

        .form-textarea {
            width: 100%;
            padding: 14px 20px;
            background: #11153c;
            border: 1.5px solid #262a5d;
            border-radius: 16px;
            color: #ffffff;
            font-size: 15px;
            outline: none;
            transition: all 0.3s ease;
            font-family: 'Poppins', sans-serif;
            min-height: 120px;
            resize: vertical;
        }

        .form-textarea:focus {
            border-color: #08c6aa;
            background: #15194d;
            box-shadow: 0 0 0 4px rgba(8, 198, 170, 0.1);
        }

        /* Advanced Chat System */
        .sb-chat-widget {
            position: fixed;
            bottom: 24px;
            left: 24px;
            z-index: 10000;
        }

        body[dir="rtl"] .sb-chat-widget {
            left: auto;
            right: 24px;
        }

        .sb-chat-bubble {
            width: 64px;
            height: 64px;
            background: linear-gradient(135deg, #08c6aa 0%, #01aba5 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            box-shadow: 0 8px 32px rgba(8, 198, 170, 0.5);
            transition: all 0.3s ease;
            position: relative;
            animation: pulse 2s infinite;
        }

        .sb-chat-bubble:hover {
            transform: scale(1.1);
            box-shadow: 0 12px 40px rgba(8, 198, 170, 0.6);
        }

        .sb-chat-icon {
            font-size: 28px;
            transition: transform 0.3s ease;
        }

        .sb-chat-badge {
            position: absolute;
            top: -4px;
            right: -4px;
            width: 24px;
            height: 24px;
            background: #f52cc1;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 12px;
            font-weight: 700;
            color: white;
            border: 3px solid #030730;
            animation: bounce 0.5s ease;
        }

        body[dir="rtl"] .sb-chat-badge {
            right: auto;
            left: -4px;
        }

        .sb-chat-container {
            position: fixed;
            bottom: 100px;
            left: 24px;
            width: 420px;
            height: 600px;
            background: linear-gradient(135deg, rgba(21, 25, 77, 0.98) 0%, rgba(17, 21, 60, 0.98) 100%);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 24px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.5);
            display: none;
            flex-direction: column;
            overflow: hidden;
            transform: scale(0.9) translateY(20px);
            opacity: 0;
            transition: all 0.4s cubic-bezier(0.68, -0.55, 0.265, 1.55);
        }

        body[dir="rtl"] .sb-chat-container {
            left: auto;
            right: 24px;
        }

        .sb-chat-container.active {
            display: flex;
            transform: scale(1) translateY(0);
            opacity: 1;
        }

        /* Chat Header */
        .sb-chat-header {
            background: linear-gradient(135deg, #08c6aa 0%, #01aba5 100%);
            padding: 20px 24px;
            display: flex;
            align-items: center;
            gap: 16px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        body[dir="ltr"] .sb-chat-header {
            flex-direction: row;
        }

        body[dir="rtl"] .sb-chat-header {
            flex-direction: row-reverse;
        }

        .sb-chat-avatar {
            width: 48px;
            height: 48px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            border: 2px solid rgba(255, 255, 255, 0.3);
        }

        .sb-chat-header-info {
            flex: 1;
        }

        .sb-chat-title {
            font-size: 18px;
            font-weight: 700;
            color: white;
            margin-bottom: 4px;
        }

        .sb-chat-status {
            font-size: 13px;
            color: rgba(255, 255, 255, 0.8);
            display: flex;
            align-items: center;
            gap: 6px;
        }

        body[dir="ltr"] .sb-chat-status {
            flex-direction: row;
        }

        body[dir="rtl"] .sb-chat-status {
            flex-direction: row-reverse;
        }

        .sb-status-dot {
            width: 8px;
            height: 8px;
            background: #4ade80;
            border-radius: 50%;
            animation: pulse 2s infinite;
        }

        .sb-chat-actions {
            display: flex;
            gap: 8px;
        }

        body[dir="ltr"] .sb-chat-actions {
            flex-direction: row;
        }

        body[dir="rtl"] .sb-chat-actions {
            flex-direction: row-reverse;
        }

        .sb-chat-action-btn {
            width: 36px;
            height: 36px;
            background: rgba(255, 255, 255, 0.15);
            border: none;
            border-radius: 10px;
            color: white;
            font-size: 18px;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .sb-chat-action-btn:hover {
            background: rgba(255, 255, 255, 0.25);
            transform: scale(1.05);
        }

        /* Messages Area */
        .sb-messages-container {
            flex: 1;
            padding: 24px;
            overflow-y: auto;
            background: rgba(3, 7, 48, 0.5);
            display: flex;
            flex-direction: column;
            gap: 16px;
        }

        .sb-messages-container::-webkit-scrollbar {
            width: 6px;
        }

        .sb-messages-container::-webkit-scrollbar-track {
            background: rgba(255, 255, 255, 0.05);
            border-radius: 10px;
        }

        .sb-messages-container::-webkit-scrollbar-thumb {
            background: rgba(8, 198, 170, 0.5);
            border-radius: 10px;
        }

        .sb-messages-container::-webkit-scrollbar-thumb:hover {
            background: rgba(8, 198, 170, 0.7);
        }

        /* Message Styles */
        .sb-message {
            display: flex;
            gap: 12px;
            animation: messageSlide 0.4s ease;
        }

        body[dir="ltr"] .sb-message {
            flex-direction: row;
        }

        body[dir="rtl"] .sb-message {
            flex-direction: row-reverse;
        }

        .sb-message.sent {
            flex-direction: row-reverse;
        }

        body[dir="rtl"] .sb-message.sent {
            flex-direction: row;
        }

        .sb-message-avatar {
            width: 36px;
            height: 36px;
            background: linear-gradient(135deg, #08c6aa 0%, #01aba5 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 16px;
            flex-shrink: 0;
        }

        .sb-message.sent .sb-message-avatar {
            background: linear-gradient(135deg, #f52cc1 0%, #e01ba5 100%);
        }

        .sb-message-content {
            max-width: 70%;
            position: relative;
        }

        .sb-message-bubble {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            padding: 12px 16px;
            border-radius: 18px;
            color: white;
            font-size: 14px;
            line-height: 1.4;
            word-wrap: break-word;
        }

        .sb-message.sent .sb-message-bubble {
            background: linear-gradient(135deg, #08c6aa 0%, #01aba5 100%);
            border: none;
        }

        /* Message Status */
        .sb-message-status {
            display: flex;
            align-items: center;
            gap: 4px;
            margin-top: 4px;
            font-size: 11px;
            color: rgba(255, 255, 255, 0.6);
        }

        body[dir="ltr"] .sb-message-status {
            flex-direction: row;
        }

        body[dir="rtl"] .sb-message-status {
            flex-direction: row-reverse;
        }

        .sb-status-icon {
            font-size: 14px;
        }

        .sb-status-single { color: rgba(255, 255, 255, 0.6); }
        .sb-status-double { color: rgba(255, 255, 255, 0.8); }
        .sb-status-read { color: #4ade80; }

        .sb-message-time {
            font-size: 11px;
            color: rgba(255, 255, 255, 0.5);
            margin-top: 4px;
        }

        body[dir="ltr"] .sb-message-time {
            text-align: right;
        }

        body[dir="rtl"] .sb-message-time {
            text-align: left;
        }

        body[dir="ltr"] .sb-message.sent .sb-message-time {
            text-align: left;
        }

        body[dir="rtl"] .sb-message.sent .sb-message-time {
            text-align: right;
        }

        /* Message Actions */
        .sb-message-actions {
            position: absolute;
            top: -20px;
            background: rgba(0, 0, 0, 0.8);
            backdrop-filter: blur(20px);
            border-radius: 8px;
            padding: 4px;
            display: none;
            gap: 4px;
            z-index: 10;
        }

        body[dir="ltr"] .sb-message-actions {
            right: 0;
            flex-direction: row;
        }

        body[dir="rtl"] .sb-message-actions {
            left: 0;
            flex-direction: row-reverse;
        }

        .sb-message:hover .sb-message-actions {
            display: flex;
        }

        .sb-action-btn {
            background: none;
            border: none;
            color: white;
            padding: 6px 8px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 12px;
            transition: background 0.2s;
        }

        .sb-action-btn:hover {
            background: rgba(255, 255, 255, 0.1);
        }

        /* Typing Indicator */
        .sb-typing-indicator {
            display: none;
            align-items: center;
            gap: 12px;
            padding: 12px 16px;
        }

        body[dir="ltr"] .sb-typing-indicator {
            flex-direction: row;
        }

        body[dir="rtl"] .sb-typing-indicator {
            flex-direction: row-reverse;
        }

        .sb-typing-indicator.active {
            display: flex;
        }

        .sb-typing-dots {
            display: flex;
            gap: 4px;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.1);
            padding: 12px 16px;
            border-radius: 16px;
        }

        body[dir="ltr"] .sb-typing-dots {
            flex-direction: row;
        }

        body[dir="rtl"] .sb-typing-dots {
            flex-direction: row-reverse;
        }

        .sb-typing-dot {
            width: 6px;
            height: 6px;
            background: #08c6aa;
            border-radius: 50%;
            animation: typing 1.4s infinite;
        }

        .sb-typing-dot:nth-child(2) { animation-delay: 0.2s; }
        .sb-typing-dot:nth-child(3) { animation-delay: 0.4s; }

        /* Input Area */
        .sb-input-container {
            padding: 16px 20px;
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(20px);
            border-top: 1px solid rgba(255, 255, 255, 0.1);
        }

        .sb-input-tools {
            display: flex;
            gap: 8px;
            margin-bottom: 12px;
        }

        body[dir="ltr"] .sb-input-tools {
            flex-direction: row;
        }

        body[dir="rtl"] .sb-input-tools {
            flex-direction: row-reverse;
        }

        .sb-tool-btn {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 10px;
            color: white;
            padding: 8px 12px;
            cursor: pointer;
            transition: all 0.2s;
            font-size: 14px;
        }

        .sb-tool-btn:hover {
            background: rgba(255, 255, 255, 0.2);
            transform: scale(1.05);
        }

        .sb-input-wrapper {
            display: flex;
            gap: 12px;
            align-items: flex-end;
        }

        body[dir="ltr"] .sb-input-wrapper {
            flex-direction: row;
        }

        body[dir="rtl"] .sb-input-wrapper {
            flex-direction: row-reverse;
        }

        .sb-chat-input {
            flex: 1;
            background: rgba(255, 255, 255, 0.1);
            border: 1.5px solid rgba(255, 255, 255, 0.1);
            border-radius: 12px;
            padding: 12px 16px;
            color: white;
            font-size: 14px;
            resize: none;
            max-height: 120px;
            min-height: 44px;
            outline: none;
            transition: all 0.3s;
            font-family: 'Poppins', sans-serif;
        }

        .sb-chat-input:focus {
            border-color: #08c6aa;
            background: rgba(255, 255, 255, 0.15);
        }

        .sb-send-btn {
            background: linear-gradient(135deg, #08c6aa 0%, #01aba5 100%);
            border: none;
            border-radius: 12px;
            color: white;
            padding: 12px 16px;
            cursor: pointer;
            transition: all 0.3s;
            flex-shrink: 0;
        }

        .sb-send-btn:hover {
            transform: scale(1.05);
            box-shadow: 0 8px 24px rgba(8, 198, 170, 0.4);
        }

        /* Animations */
        @keyframes messageSlide {
            from {
                opacity: 0;
                transform: translateY(10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes typing {
            0%, 60%, 100% { transform: translateY(0); opacity: 0.7; }
            30% { transform: translateY(-5px); opacity: 1; }
        }

        @keyframes bounce {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.2); }
        }

        /* Mobile Styles */
        @media (max-width: 1024px) {
            .hero-card {
                grid-template-columns: 1fr;
                gap: 40px;
                padding: 40px;
            }

            .visual-container {
                max-width: 400px;
            }

            .central-mascot {
                width: 200px;
                height: 200px;
                font-size: 100px;
            }

            .orbit-icon {
                width: 64px;
                height: 64px;
                font-size: 28px;
            }
        }

        @media (max-width: 768px) {
            header {
                padding: 12px 20px;
            }

            .nav-links,
            .auth-buttons {
                display: none;
            }

            .mobile-menu-toggle {
                display: block;
            }

            nav.mobile-open {
                position: fixed;
                top: 76px;
                left: 0;
                width: 100%;
                background: rgba(3, 7, 48, 0.98);
                backdrop-filter: blur(20px);
                padding: 24px;
                flex-direction: column;
                align-items: flex-start;
                gap: 20px;
                border-top: 1px solid rgba(255, 255, 255, 0.1);
            }

            body[dir="ltr"] nav.mobile-open {
                flex-direction: column;
            }

            body[dir="rtl"] nav.mobile-open {
                flex-direction: column;
            }

            nav.mobile-open .nav-links,
            nav.mobile-open .auth-buttons {
                display: flex;
                flex-direction: column;
                width: 100%;
                gap: 16px;
            }

            nav.mobile-open .nav-links a {
                padding: 12px 0;
                width: 100%;
            }

            nav.mobile-open .btn-secondary,
            nav.mobile-open .btn-primary {
                width: 100%;
                justify-content: center;
            }

            main {
                padding: 32px 20px;
            }

            .hero-card {
                padding: 32px 24px;
            }

            .hero-headline {
                font-size: 36px;
            }

            .hero-description {
                font-size: 15px;
            }

            .hero-cta {
                flex-direction: column;
            }

            .btn-large,
            .btn-secondary-large {
                width: 100%;
                text-align: center;
            }

            .visual-container {
                max-width: 300px;
            }

            .central-mascot {
                width: 160px;
                height: 160px;
                font-size: 80px;
            }

            .orbit-icon {
                width: 56px;
                height: 56px;
                font-size: 24px;
            }

            .features-grid {
                grid-template-columns: 1fr;
            }

            .section-title {
                font-size: 32px;
            }

            .auth-modal {
                padding: 32px 24px;
            }

            .form-row {
                grid-template-columns: 1fr;
            }

            .social-auth {
                grid-template-columns: 1fr;
            }

            .games-grid {
                grid-template-columns: 1fr;
            }

            .page-title {
                font-size: 36px;
            }

            .sb-chat-container {
                left: 12px;
                right: 12px;
                bottom: 90px;
                width: calc(100% - 24px);
                max-width: 100%;
                height: 500px;
            }

            body[dir="rtl"] .sb-chat-container {
                left: 12px;
                right: 12px;
            }

            .sb-chat-bubble {
                bottom: 12px;
                left: 12px;
            }

            body[dir="rtl"] .sb-chat-bubble {
                left: auto;
                right: 12px;
            }

            .language-switcher {
                margin: 0 10px;
            }
        }

        /* Notification Toast */
        .toast {
            position: fixed;
            top: 100px;
            right: 20px;
            background: linear-gradient(135deg, #08c6aa 0%, #01aba5 100%);
            color: white;
            padding: 16px 24px;
            border-radius: 16px;
            box-shadow: 0 12px 32px rgba(0, 0, 0, 0.4);
            z-index: 10000;
            animation: slideInRight 0.4s ease, slideOutRight 0.4s ease 3.6s;
            max-width: 400px;
        }

        body[dir="rtl"] .toast {
            right: auto;
            left: 20px;
            animation: slideInLeft 0.4s ease, slideOutLeft 0.4s ease 3.6s;
        }

        @keyframes slideInRight {
            from { transform: translateX(400px); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }

        @keyframes slideOutRight {
            from { transform: translateX(0); opacity: 1; }
            to { transform: translateX(400px); opacity: 0; }
        }

        @keyframes slideInLeft {
            from { transform: translateX(-400px); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }

        @keyframes slideOutLeft {
            from { transform: translateX(0); opacity: 1; }
            to { transform: translateX(-400px); opacity: 0; }
        }

        .toast.error {
            background: linear-gradient(135deg, #f52cc1 0%, #e01ba5 100%);
        }

        .toast.success {
            background: linear-gradient(135deg, #08c6aa 0%, #01aba5 100%);
        }
    </style>
</head>
<body dir="rtl">
    <!-- Starry Background -->
    <div class="stars" id="stars"></div>
    
    <!-- Blob Clouds -->
    <div class="blob blob-1"></div>
    <div class="blob blob-2"></div>
    <div class="blob blob-3"></div>
    
    <!-- Header -->
    <header>
        <div class="header-content">
            <div class="logo-section" onclick="showPage('home')">
                <div class="mascot-logo">
                    <div class="mascot-glow"></div>
                    <span class="mascot-face">😊</span>
                </div>
                <div class="brand-text">
                    <h1 id="brand-name">Telbet</h1>
                    <p id="brand-tagline">بازی و سرگرمی</p>
                </div>
            </div>
            
            <div class="language-switcher">
                <button class="lang-btn" onclick="changeLanguage('en')">EN</button>
                <button class="lang-btn active" onclick="changeLanguage('fa')">FA</button>
            </div>
            
            <nav id="mainNav">
                <ul class="nav-links">
                    <li><a class="nav-link active" data-page="home">خانه</a></li>
                    <li><a class="nav-link" data-page="casino">کازینو</a></li>
                    <li><a class="nav-link" data-page="live">زنده</a></li>
                    <li><a class="nav-link" data-page="sports">ورزشی</a></li>
                    <li><a class="nav-link" data-page="promotions">تخفیف ها</a></li>
                    <li><a class="nav-link" data-page="support">پشتیبانی</a></li>
                </ul>
                <div class="auth-buttons" id="authButtons">
                    <button class="btn-secondary" onclick="openAuthModal('login')">ورود</button>
                    <button class="btn-primary" onclick="openAuthModal('signup')">ثبت نام</button>
                </div>
                <div class="user-profile" id="userProfile">
                    <div class="profile-avatar" onclick="toggleProfileDropdown()">
                        <span id="profileInitials">TU</span>
                    </div>
                    <div class="profile-dropdown" id="profileDropdown">
                        <div class="profile-info">
                            <div class="profile-name" id="profileName">Telbet User</div>
                            <div class="profile-email" id="profileEmail">user@telbet.com</div>
                        </div>
                        <div class="profile-balance">
                            <div class="balance-label">موجودی</div>
                            <div class="balance-amount" id="profileBalance">$1,250.00</div>
                        </div>
                        <ul class="profile-menu">
                            <li onclick="showComingSoon('صفحه پروفایل')"><span>👤</span> پروفایل من</li>
                            <li onclick="showComingSoon('صفحه کیف پول')"><span>💰</span> کیف پول</li>
                            <li onclick="showComingSoon('تاریخچه بازی')"><span>🎮</span> تاریخچه بازی</li>
                            <li onclick="showComingSoon('صفحه جایزه ها')"><span>🎁</span> جایزه های من</li>
                            <li onclick="showComingSoon('تنظیمات')"><span>⚙️</span> تنظیمات</li>
                            <li class="logout" onclick="logout()"><span>🚪</span> خروج</li>
                        </ul>
                    </div>
                </div>
            </nav>
            <button class="mobile-menu-toggle" id="menuToggle">
                <span>☰</span>
            </button>
        </div>
    </header>

    <!-- Auth Modal -->
    <div class="modal-overlay" id="authModal">
        <div class="auth-modal">
            <button class="modal-close" onclick="closeAuthModal()">✕</button>
            
            <!-- Login Form -->
            <div id="loginForm">
                <div class="auth-header">
                    <h2 class="auth-title">خوش آمدید! 🎮</h2>
                    <p class="auth-subtitle">برای ادامه سفر بازی خود وارد شوید</p>
                </div>
                <form onsubmit="handleLogin(event)">
                    <div class="form-group">
                        <label class="form-label">ایمیل یا نام کاربری</label>
                        <input type="text" class="form-input" placeholder="ایمیل یا نام کاربری خود را وارد کنید" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">رمز عبور</label>
                        <input type="password" class="form-input" placeholder="رمز عبور خود را وارد کنید" required>
                    </div>
                    <div class="form-checkbox">
                        <input type="checkbox" id="remember">
                        <label for="remember">مرا به خاطر بسپار</label>
                    </div>
                    <button type="submit" class="auth-submit">ورود</button>
                </form>
                <div class="auth-divider">
                    <span>یا با ادامه دهید</span>
                </div>
                <div class="social-auth">
                    <button class="social-btn" onclick="showComingSoon('ورود با گوگل')">
                        <span>🔍</span> گوگل
                    </button>
                    <button class="social-btn" onclick="showComingSoon('ورود با فیسبوک')">
                        <span>📘</span> فیسبوک
                    </button>
                </div>
                <div class="auth-footer">
                    حساب کاربری ندارید؟ <a onclick="switchAuthMode('signup')">ثبت نام</a>
                </div>
            </div>
            
            <!-- Signup Form -->
            <div id="signupForm" style="display: none;">
                <div class="auth-header">
                    <h2 class="auth-title">به تلبت بپیوندید! 🌟</h2>
                    <p class="auth-subtitle">حساب کاربری خود را ایجاد کنید و بازی را شروع کنید</p>
                </div>
                <form onsubmit="handleSignup(event)">
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label">نام</label>
                            <input type="text" class="form-input" placeholder="جان" required>
                        </div>
                        <div class="form-group">
                            <label class="form-label">نام خانوادگی</label>
                            <input type="text" class="form-input" placeholder="دو" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="form-label">ایمیل</label>
                        <input type="email" class="form-input" placeholder="john.doe@example.com" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">نام کاربری</label>
                        <input type="text" class="form-input" placeholder="johndoe123" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">رمز عبور</label>
                        <input type="password" class="form-input" placeholder="یک رمز عبور قوی ایجاد کنید" required>
                    </div>
                    <div class="form-checkbox">
                        <input type="checkbox" id="terms" required>
                        <label for="terms">من با شرایط و ضوابط موافقم</label>
                    </div>
                    <button type="submit" class="auth-submit">ایجاد حساب</button>
                </form>
                <div class="auth-divider">
                    <span>یا با ثبت نام کنید</span>
                </div>
                <div class="social-auth">
                    <button class="social-btn" onclick="showComingSoon('ثبت نام با گوگل')">
                        <span>🔍</span> گوگل
                    </button>
                    <button class="social-btn" onclick="showComingSoon('ثبت نام با فیسبوک')">
                        <span>📘</span> فیسبوک
                    </button>
                </div>
                <div class="auth-footer">
                    قبلاً حساب کاربری دارید؟ <a onclick="switchAuthMode('login')">ورود</a>
                </div>
            </div>
        </div>
    </div>
    
    
        <!-- Main Content -->
    <main>
        <!-- Home Page -->
        <div class="page-content active" id="homePage">
            <section class="hero-card">
                <div class="hero-content">
                    <span class="welcome-label" id="hero-welcome">به تلبت خوش آمدید</span>
                    <h2 class="hero-headline">هوشمندانه بازی کن زیر <span class="highlight">آسمان شب</span></h2>
                    <p class="hero-description" id="hero-description">پلتفرم بازی نهایی را با گرافیک خیره کننده، سرگرمی بی پایان و لذت برنده شدن تجربه کنید. به هزاران بازیکن در پیشرفته ترین جهان بازی بپیوندید.</p>
                    <div class="hero-cta">
                        <button class="btn-primary btn-large" onclick="openAuthModal('signup')">شروع بازی</button>
                        <button class="btn-secondary-large" onclick="showPage('promotions')">مشاهده جایزه ها</button>
                    </div>
                </div>
                <div class="hero-visual">
                    <div class="visual-container">
                        <div class="orbit-icon">🎮</div>
                        <div class="orbit-icon">🎰</div>
                        <div class="orbit-icon">⚡</div>
                        <div class="orbit-icon">🎲</div>
                        <div class="central-mascot"><span>🌟</span></div>
                    </div>
                </div>
            </section>
            
            <section class="features-section">
                <div class="section-header">
                    <h2 class="section-title">چرا تلبت را انتخاب کنید؟</h2>
                    <p class="section-subtitle">کشف کنید چه چیزی ما را به پلتفرم پیشرو بازی و سرگرمی تبدیل کرده است</p>
                </div>
                <div class="features-grid">
                    <div class="feature-card" onclick="showPage('casino')">
                        <div class="feature-icon">🎮</div>
                        <h3 class="feature-title">کتابخانه بازی گسترده</h3>
                        <p class="feature-description">هزاران بازی پریمیوم در تمام ژانرها را کاوش کنید. از بازی های محبوب کلاسیک کازینو گرفته تا تجربیات زنده پیشرفته.</p>
                        <a class="feature-link"> مرور بازی ها <span>→</span> </a>
                    </div>
                    <div class="feature-card" onclick="showPage('promotions')">
                        <div class="feature-icon">⚡</div>
                        <h3 class="feature-title">پاداش فوری</h3>
                        <p class="feature-description">از روز اول با جایزه های سخاوتمندانه، چالش های روزانه و مزایای ویژه VIP برای بازیکنان وفادار پاداش بگیرید.</p>
                        <a class="feature-link"> مشاهده جایزه ها <span>→</span> </a>
                    </div>
                    <div class="feature-card" onclick="showComingSoon('صفحه امنیت')">
                        <div class="feature-icon">🔒</div>
                        <h3 class="feature-title">امن و منصفانه</h3>
                        <p class="feature-description">با اطمینان بازی کنید و بدانید که داده های شما با پیشرفته ترین رمزگذاری و بازی های منصفانه تأیید شده محافظت می شود.</p>
                        <a class="feature-link"> درباره امنیت بدانید <span>→</span> </a>
                    </div>
                    <div class="feature-card" onclick="showPage('support')">
                        <div class="feature-icon">💬</div>
                        <h3 class="feature-title">پشتیبانی 24/7</h3>
                        <p class="feature-description">تیم پشتیبانی دوستانه ما همیشه در اینجا است. از طریق چت زنده، ایمیل یا تلفن کمک فوری دریافت کنید.</p>
                        <a class="feature-link"> تماس با پشتیبانی <span>→</span> </a>
                    </div>
                </div>
            </section>
        </div>

        <!-- Casino Page -->
        <div class="page-content" id="casinoPage">
            <div class="page-header">
                <h1 class="page-title">🎰 بازی های کازینو</h1>
                <p class="page-subtitle">بهترین بازی های کازینو را با گرافیک فوق العاده و بردهای بزرگ بازی کنید</p>
            </div>
            <div class="category-tabs">
                <button class="category-tab active">همه بازی ها</button>
                <button class="category-tab">اسلات ها</button>
                <button class="category-tab">بازی های میزی</button>
                <button class="category-tab">جکپات ها</button>
                <button class="category-tab">انتشارات جدید</button>
            </div>
            <div class="games-grid" id="casinoGames">
                <!-- Games will be loaded by JavaScript -->
            </div>
        </div>

        <!-- Live Page -->
        <div class="page-content" id="livePage">
            <div class="page-header">
                <h1 class="page-title">🎥 کازینو زنده</h1>
                <p class="page-subtitle">با دیلرهای واقعی در زمان واقعی برای یک تجربه کازینو اصیل بازی کنید</p>
            </div>
            <div class="category-tabs">
                <button class="category-tab active">همه لایوها</button>
                <button class="category-tab">رولت</button>
                <button class="category-tab">بلک جک</button>
                <button class="category-tab">باکارات</button>
                <button class="category-tab">پوکر</button>
            </div>
            <div class="games-grid" id="liveGames">
                <!-- Games will be loaded by JavaScript -->
            </div>
        </div>

        <!-- Sports Page -->
        <div class="page-content" id="sportsPage">
            <div class="page-header">
                <h1 class="page-title">⚽ شرط بندی ورزشی</h1>
                <p class="page-subtitle">روی ورزش های مورد علاقه خود با بهترین odds و گزینه های شرط بندی زنده شرط بندی کنید</p>
            </div>
            <div class="category-tabs">
                <button class="category-tab active">همه ورزش ها</button>
                <button class="category-tab">فوتبال</button>
                <button class="category-tab">بسکتبال</button>
                <button class="category-tab">تنیس</button>
                <button class="category-tab">ای-اسپورت</button>
            </div>
            <div class="games-grid" id="sportsGames">
                <!-- Games will be loaded by JavaScript -->
            </div>
        </div>

        <!-- Promotions Page -->
        <div class="page-content" id="promotionsPage">
            <div class="page-header">
                <h1 class="page-title">🎁 تخفیف ها و جایزه ها</h1>
                <p class="page-subtitle">جایزه ها و پاداش های انحصاری طراحی شده برای برندگان را دریافت کنید</p>
            </div>
            <div class="features-grid" id="promotionsList">
                <!-- Promotions will be loaded by JavaScript -->
            </div>
        </div>

        <!-- Support Page -->
        <div class="page-content" id="supportPage">
            <div class="page-header">
                <h1 class="page-title">💬 مرکز پشتیبانی</h1>
                <p class="page-subtitle">ما 24/7 در خدمت شما هستیم. پاسخ های فوری دریافت کنید یا با تیم ما تماس بگیرید</p>
            </div>
            <div class="faq-grid" id="faqList">
                <!-- FAQs will be loaded by JavaScript -->
            </div>
            <div class="contact-form">
                <h3 style="font-size: 24px; margin-bottom: 24px; text-align: center;">پیامی برای ما بفرستید</h3>
                <form onsubmit="handleSupportForm(event)">
                    <div class="form-group">
                        <label class="form-label">نام شما</label>
                        <input type="text" class="form-input" placeholder="جان دو" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">آدرس ایمیل</label>
                        <input type="email" class="form-input" placeholder="john@example.com" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">موضوع</label>
                        <input type="text" class="form-input" placeholder="چطور می توانیم کمک کنیم؟" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">پیام</label>
                        <textarea class="form-textarea" placeholder="مشکل یا سوال خود را شرح دهید..." required></textarea>
                    </div>
                    <button type="submit" class="auth-submit">ارسال پیام</button>
                </form>
            </div>
        </div>
    </main>

    <!-- Advanced Chat System -->
    <div class="sb-chat-widget" id="chatWidget">
        <div class="sb-chat-bubble" onclick="toggleChat()">
            <span class="sb-chat-icon">💬</span>
            <span class="sb-chat-badge" id="chatBadge">3</span>
        </div>
        
        <div class="sb-chat-container" id="chatContainer">
            <!-- Chat content will be dynamically generated -->
        </div>
    </div>

    <!-- Coming Soon Modal -->
    <div class="modal-overlay" id="comingSoonModal">
        <div class="auth-modal">
            <button class="modal-close" onclick="closeComingSoonModal()">✕</button>
            <div class="auth-header">
                <h2 class="auth-title">🚧 به زودی!</h2>
                <p class="auth-subtitle" id="comingSoonMessage">این قابلیت در حال توسعه است و به زودی در دسترس قرار خواهد گرفت</p>
            </div>
            <div style="text-align: center; margin-top: 32px;">
                <div style="font-size: 64px; margin-bottom: 24px;">👨‍💻</div>
                <p style="color: #d5d8e6; margin-bottom: 32px;">تیم ما در حال کار بر روی این ویژگی هیجان انگیز است</p>
                <button class="btn-primary" onclick="closeComingSoonModal()">متوجه شدم</button>
            </div>
        </div>
    </div>

    <script>
        // Configuration
        const defaultConfig = {
            brand_name: "Telbet",
            brand_tagline: "بازی و سرگرمی",
            hero_welcome: "به تلبت خوش آمدید",
            hero_headline: "هوشمندانه بازی کن زیر آسمان شب",
            hero_description: "پلتفرم بازی نهایی را با گرافیک خیره کننده، سرگرمی بی پایان و لذت برنده شدن تجربه کنید. به هزاران بازیکن در پیشرفته ترین جهان بازی بپیوندید.",
            primary_cta: "شروع بازی",
            secondary_cta: "مشاهده جایزه ها"
        };

        // Current user state
        let currentUser = null;
        let isLoggedIn = false;

        // Language configuration
        const translations = {
            en: {
                // Header & Navigation
                brand_tagline: "Games & entertainment",
                nav_home: "Home",
                nav_casino: "Casino", 
                nav_live: "Live",
                nav_sports: "Sports",
                nav_promotions: "Promotions",
                nav_support: "Support",
                login_btn: "Log in",
                signup_btn: "Sign up",
                
                // Hero Section
                hero_welcome: "Welcome to Telbet",
                hero_headline: "Play smart under the night sky",
                hero_description: "Experience the ultimate gaming platform with stunning graphics, endless entertainment, and the thrill of winning. Join thousands of players in the most advanced gaming universe.",
                start_playing: "Start playing",
                view_bonuses: "View bonuses",
                
                // Features
                features_title: "Why Choose Telbet?",
                features_subtitle: "Discover what makes us the leading games and entertainment platform",
                feature1_title: "Vast Game Library",
                feature1_desc: "Explore thousands of premium games across all genres. From classic casino favorites to cutting-edge live experiences.",
                feature1_link: "Browse games",
                feature2_title: "Instant Rewards", 
                feature2_desc: "Get rewarded from day one with generous bonuses, daily challenges, and exclusive VIP perks for loyal players.",
                feature2_link: "View bonuses",
                feature3_title: "Secure & Fair",
                feature3_desc: "Play with confidence knowing your data is protected with state-of-the-art encryption and certified fair gaming.",
                feature3_link: "Learn about security",
                feature4_title: "24/7 Support",
                feature4_desc: "Our friendly support team is always here to help. Get instant assistance through live chat, email, or phone.",
                feature4_link: "Contact support",
                
                // Chat System
                chat_title: "Telbet Support",
                chat_status: "Online",
                chat_placeholder: "Type your message...",
                chat_typing: "is typing...",
                chat_welcome1: "Hello! Welcome to Telbet 👋",
                chat_welcome2: "How can I help you today?",
                chat_offline: "Offline",
                message_sent: "Message sent",
                message_delivered: "Delivered", 
                message_read: "Read",
                
                // Message Actions
                action_edit: "Edit",
                action_delete: "Delete",
                action_reply: "Reply",
                action_react: "Add reaction",
                
                // Profile
                profile_balance: "Balance",
                profile_profile: "My Profile",
                profile_wallet: "Wallet",
                profile_history: "Game History",
                profile_bonuses: "My Bonuses",
                profile_settings: "Settings",
                profile_logout: "Logout"
            },
            fa: {
                // Header & Navigation
                brand_tagline: "بازی و سرگرمی",
                nav_home: "خانه",
                nav_casino: "کازینو",
                nav_live: "زنده", 
                nav_sports: "ورزشی",
                nav_promotions: "تخفیف ها",
                nav_support: "پشتیبانی",
                login_btn: "ورود",
                signup_btn: "ثبت نام",
                
                // Hero Section
                hero_welcome: "به تلبت خوش آمدید",
                hero_headline: "هوشمندانه بازی کن زیر آسمان شب",
                hero_description: "پلتفرم بازی نهایی را با گرافیک خیره کننده، سرگرمی بی پایان و لذت برنده شدن تجربه کنید. به هزاران بازیکن در پیشرفته ترین جهان بازی بپیوندید.",
                start_playing: "شروع بازی",
                view_bonuses: "مشاهده جایزه ها",
                
                // Features
                features_title: "چرا تلبت را انتخاب کنید؟",
                features_subtitle: "کشف کنید چه چیزی ما را به پلتفرم پیشرو بازی و سرگرمی تبدیل کرده است",
                feature1_title: "کتابخانه بازی گسترده",
                feature1_desc: "هزاران بازی پریمیوم در تمام ژانرها را کاوش کنید. از بازی های محبوب کلاسیک کازینو گرفته تا تجربیات زنده پیشرفته.",
                feature1_link: "مرور بازی ها",
                feature2_title: "پاداش فوری",
                feature2_desc: "از روز اول با جایزه های سخاوتمندانه، چالش های روزانه و مزایای ویژه VIP برای بازیکنان وفادار پاداش بگیرید.",
                feature2_link: "مشاهده جایزه ها", 
                feature3_title: "امن و منصفانه",
                feature3_desc: "با اطمینان بازی کنید و بدانید که داده های شما با پیشرفته ترین رمزگذاری و بازی های منصفانه تأیید شده محافظت می شود.",
                feature3_link: "درباره امنیت بدانید",
                feature4_title: "پشتیبانی 24/7",
                feature4_desc: "تیم پشتیبانی دوستانه ما همیشه در اینجا است. از طریق چت زنده، ایمیل یا تلفن کمک فوری دریافت کنید.",
                feature4_link: "تماس با پشتیبانی",
                
                // Chat System
                chat_title: "پشتیبانی تلبت",
                chat_status: "آنلاین",
                chat_placeholder: "پیام خود را بنویسید...",
                chat_typing: "در حال تایپ...",
                chat_welcome1: "سلام! به تلبت خوش آمدید 👋",
                chat_welcome2: "چطور میتونم کمکتون کنم؟",
                chat_offline: "آفلاین",
                message_sent: "پیام ارسال شد",
                message_delivered: "تحویل داده شد",
                message_read: "خوانده شد",
                
                // Message Actions
                action_edit: "ویرایش",
                action_delete: "حذف",
                action_reply: "پاسخ",
                action_react: "واکنش",
                
                // Profile
                profile_balance: "موجودی",
                profile_profile: "پروفایل من",
                profile_wallet: "کیف پول",
                profile_history: "تاریخچه بازی",
                profile_bonuses: "جایزه های من",
                profile_settings: "تنظیمات",
                profile_logout: "خروج"
            }
        };

        let currentLanguage = 'fa';
        let chatInstance = null;

        // Language Management
        function changeLanguage(lang) {
            currentLanguage = lang;
            
            // Update UI direction
            document.body.dir = lang === 'fa' ? 'rtl' : 'ltr';
            
            // Update language buttons
            document.querySelectorAll('.lang-btn').forEach(btn => {
                btn.classList.remove('active');
            });
            event.target.classList.add('active');
            
            // Update all translatable elements
            updatePageContent();
            
            // Update chat if it exists
            if (chatInstance) {
                chatInstance.updateLanguage();
            }
        }

        function updatePageContent() {
            const t = translations[currentLanguage];
            
            // Update specific elements
            const elements = {
                'brand-tagline': t.brand_tagline,
                'hero-welcome': t.hero_welcome,
                'hero-description': t.hero_description
            };
            
            Object.keys(elements).forEach(id => {
                const element = document.getElementById(id);
                if (element) {
                    element.textContent = elements[id];
                }
            });
            
            // Update navigation links
            const navLinks = document.querySelectorAll('.nav-link');
            if (navLinks.length > 0) {
                navLinks[0].textContent = t.nav_home;
                navLinks[1].textContent = t.nav_casino;
                navLinks[2].textContent = t.nav_live;
                navLinks[3].textContent = t.nav_sports;
                navLinks[4].textContent = t.nav_promotions;
                navLinks[5].textContent = t.nav_support;
            }
            
            // Update auth buttons
            const authButtons = document.querySelectorAll('.auth-buttons button');
            if (authButtons.length > 0) {
                authButtons[0].textContent = t.login_btn;
                authButtons[1].textContent = t.signup_btn;
            }
            
            // Update profile menu
            const profileItems = document.querySelectorAll('.profile-menu li');
            if (profileItems.length > 0) {
                profileItems[0].innerHTML = `<span>👤</span> ${t.profile_profile}`;
                profileItems[1].innerHTML = `<span>💰</span> ${t.profile_wallet}`;
                profileItems[2].innerHTML = `<span>🎮</span> ${t.profile_history}`;
                profileItems[3].innerHTML = `<span>🎁</span> ${t.profile_bonuses}`;
                profileItems[4].innerHTML = `<span>⚙️</span> ${t.profile_settings}`;
                profileItems[5].innerHTML = `<span>🚪</span> ${t.profile_logout}`;
            }
            
            // Update balance label
            const balanceLabel = document.querySelector('.balance-label');
            if (balanceLabel) {
                balanceLabel.textContent = t.profile_balance;
            }
        }

        // Advanced Chat System
        class AdvancedChat {
            constructor() {
                this.messages = [];
                this.currentEditId = null;
                this.isTyping = false;
                this.init();
            }

            init() {
                this.renderChat();
                this.loadSampleMessages();
                this.setupEventListeners();
            }

            renderChat() {
                const t = translations[currentLanguage];
                const chatContainer = document.getElementById('chatContainer');
                
                chatContainer.innerHTML = `
                    <div class="sb-chat-header">
                        <div class="sb-chat-avatar">💬</div>
                        <div class="sb-chat-header-info">
                            <div class="sb-chat-title">${t.chat_title}</div>
                            <div class="sb-chat-status">
                                <span class="sb-status-dot"></span>
                                ${t.chat_status}
                            </div>
                        </div>
                        <div class="sb-chat-actions">
                            <button class="sb-chat-action-btn" onclick="chat.minimize()">−</button>
                            <button class="sb-chat-action-btn" onclick="chat.close()">✕</button>
                        </div>
                    </div>
                    
                    <div class="sb-messages-container" id="sbMessages">
                        <!-- Messages will be dynamically added here -->
                    </div>
                    
                    <div class="sb-typing-indicator" id="sbTypingIndicator">
                        <div class="sb-message-avatar">💬</div>
                        <div class="sb-typing-dots">
                            <div class="sb-typing-dot"></div>
                            <div class="sb-typing-dot"></div>
                            <div class="sb-typing-dot"></div>
                        </div>
                    </div>
                    
                    <div class="sb-input-container">
                        <div class="sb-input-tools">
                            <button class="sb-tool-btn" onclick="chat.toggleEmojiPicker()">😊</button>
                            <button class="sb-tool-btn" onclick="chat.attachFile()">📎</button>
                            <button class="sb-tool-btn" onclick="chat.attachImage()">🖼️</button>
                        </div>
                        <div class="sb-input-wrapper">
                            <textarea class="sb-chat-input" id="sbChatInput" 
                                      placeholder="${t.chat_placeholder}" 
                                      rows="1"></textarea>
                            <button class="sb-send-btn" onclick="chat.sendMessage()">
                                ➤
                            </button>
                        </div>
                    </div>
                `;
            }

            loadSampleMessages() {
                const t = translations[currentLanguage];
                
                const sampleMessages = [
                    {
                        id: 1,
                        text: t.chat_welcome1,
                        sender: "support",
                        time: this.getCurrentTime(),
                        status: "read"
                    },
                    {
                        id: 2,
                        text: t.chat_welcome2,
                        sender: "support", 
                        time: this.getCurrentTime(),
                        status: "read"
                    }
                ];

                sampleMessages.forEach(msg => this.addMessage(msg, false));
            }

            addMessage(messageData, animate = true) {
                const messagesContainer = document.getElementById('sbMessages');
                const messageElement = this.createMessageElement(messageData, animate);
                messagesContainer.appendChild(messageElement);
                
                if (animate) {
                    messageElement.scrollIntoView({ behavior: 'smooth' });
                }
                
                this.messages.push(messageData);
                this.scrollToBottom();
            }

            createMessageElement(message, animate = true) {
                const t = translations[currentLanguage];
                const messageDiv = document.createElement('div');
                messageDiv.className = `sb-message ${message.sender === 'user' ? 'sent' : ''}`;
                messageDiv.dataset.messageId = message.id;

                if (animate) {
                    messageDiv.style.animation = 'messageSlide 0.3s ease-out';
                }

                const statusIcon = this.getStatusIcon(message.status);
                const statusText = this.getStatusText(message.status);
                
                messageDiv.innerHTML = `
                    <div class="sb-message-avatar">
                        ${message.sender === 'user' ? '👤' : '💬'}
                    </div>
                    <div class="sb-message-content">
                        <div class="sb-message-bubble">
                            ${message.text}
                        </div>
                        <div class="sb-message-actions">
                            <button class="sb-action-btn" onclick="chat.reactToMessage(${message.id}, '👍')">👍</button>
                            <button class="sb-action-btn" onclick="chat.reactToMessage(${message.id}, '❤️')">❤️</button>
                            <button class="sb-action-btn" onclick="chat.editMessage(${message.id})">${t.action_edit}</button>
                            <button class="sb-action-btn" onclick="chat.deleteMessage(${message.id})">${t.action_delete}</button>
                        </div>
                        <div class="sb-message-status">
                            <span class="sb-message-time">${message.time}</span>
                            ${message.sender === 'user' ? `
                                <span class="sb-status-icon ${this.getStatusClass(message.status)}">
                                    ${statusIcon}
                                </span>
                            ` : ''}
                        </div>
                    </div>
                `;

                return messageDiv;
            }

            getStatusIcon(status) {
                switch(status) {
                    case 'sent': return '✓';
                    case 'delivered': return '✓✓';
                    case 'read': return '✓✓';
                    default: return '✓';
                }
            }

            getStatusText(status) {
                const t = translations[currentLanguage];
                switch(status) {
                    case 'sent': return t.message_sent;
                    case 'delivered': return t.message_delivered;
                    case 'read': return t.message_read;
                    default: return t.message_sent;
                }
            }

            getStatusClass(status) {
                switch(status) {
                    case 'sent': return 'sb-status-single';
                    case 'delivered': return 'sb-status-double';
                    case 'read': return 'sb-status-read';
                    default: return 'sb-status-single';
                }
            }

            sendMessage() {
                const input = document.getElementById('sbChatInput');
                const text = input.value.trim();
                
                if (!text) return;

                const newMessage = {
                    id: Date.now(),
                    text: text,
                    sender: 'user',
                    time: this.getCurrentTime(),
                    status: 'sent'
                };

                this.addMessage(newMessage);
                input.value = '';

                // Simulate message delivery and read status
                setTimeout(() => this.updateMessageStatus(newMessage.id, 'delivered'), 1000);
                setTimeout(() => this.updateMessageStatus(newMessage.id, 'read'), 3000);

                // Simulate typing and reply
                setTimeout(() => this.simulateTyping(), 1000);
                setTimeout(() => this.simulateReply(), 3000);
            }

            simulateTyping() {
                this.showTypingIndicator();
            }

            simulateReply() {
                const t = translations[currentLanguage];
                const replies = [
                    "Thank you for your message! Our team will respond shortly. ✅",
                    "We've received your inquiry and will get back to you soon.",
                    "Thanks for reaching out! Let me check that for you...",
                    "I understand your question. Let me provide you with the details."
                ];
                
                const faReplies = [
                    "ممنون از پیام شما! تیم ما به زودی پاسخ خواهد داد. ✅",
                    "سوال شما دریافت شد و به زودی با شما تماس خواهیم گرفت.",
                    "ممنون از تماس شما! بگذارید این موضوع را بررسی کنم...",
                    "سوال شما را متوجه شدم. اجازه دهید جزئیات را در اختیارتان قرار دهم."
                ];

                const randomReply = currentLanguage === 'fa' ? 
                    faReplies[Math.floor(Math.random() * faReplies.length)] :
                    replies[Math.floor(Math.random() * replies.length)];
                
                this.hideTypingIndicator();
                
                const replyMessage = {
                    id: Date.now(),
                    text: randomReply,
                    sender: 'support',
                    time: this.getCurrentTime(),
                    status: 'read'
                };

                this.addMessage(replyMessage);
            }

            showTypingIndicator() {
                const indicator = document.getElementById('sbTypingIndicator');
                if (indicator) {
                    indicator.classList.add('active');
                    this.scrollToBottom();
                }
            }

            hideTypingIndicator() {
                const indicator = document.getElementById('sbTypingIndicator');
                if (indicator) {
                    indicator.classList.remove('active');
                }
            }

            updateMessageStatus(messageId, status) {
                const message = this.messages.find(m => m.id === messageId);
                if (message) {
                    message.status = status;
                    this.updateMessageDisplay(messageId);
                }
            }

            updateMessageDisplay(messageId) {
                const messageElement = document.querySelector(`[data-message-id="${messageId}"]`);
                if (messageElement) {
                    const message = this.messages.find(m => m.id === messageId);
                    const statusElement = messageElement.querySelector('.sb-status-icon');
                    if (statusElement) {
                        statusElement.className = `sb-status-icon ${this.getStatusClass(message.status)}`;
                        statusElement.textContent = this.getStatusIcon(message.status);
                    }
                }
            }

            editMessage(messageId) {
                const message = this.messages.find(m => m.id === messageId);
                if (!message || message.sender !== 'user') return;

                this.currentEditId = messageId;
                const input = document.getElementById('sbChatInput');
                input.value = message.text;
                input.focus();
            }

            deleteMessage(messageId) {
                this.messages = this.messages.filter(m => m.id !== messageId);
                const messageElement = document.querySelector(`[data-message-id="${messageId}"]`);
                if (messageElement) {
                    messageElement.style.animation = 'messageSlide 0.3s ease-out reverse';
                    setTimeout(() => messageElement.remove(), 300);
                }
            }

            reactToMessage(messageId, reaction) {
                const message = this.messages.find(m => m.id === messageId);
                if (message) {
                    if (!message.reactions) message.reactions = [];
                    if (!message.reactions.includes(reaction)) {
                        message.reactions.push(reaction);
                        this.updateReactionsDisplay(messageId);
                    }
                }
            }

            updateReactionsDisplay(messageId) {
                // Implementation for reactions display
            }

            getCurrentTime() {
                return new Date().toLocaleTimeString(currentLanguage === 'fa' ? 'fa-IR' : 'en-US', { 
                    hour: '2-digit', 
                    minute: '2-digit' 
                });
            }

            scrollToBottom() {
                const messagesContainer = document.getElementById('sbMessages');
                if (messagesContainer) {
                    setTimeout(() => {
                        messagesContainer.scrollTop = messagesContainer.scrollHeight;
                    }, 100);
                }
            }

            setupEventListeners() {
                const input = document.getElementById('sbChatInput');
                if (input) {
                    input.addEventListener('keydown', (e) => {
                        if (e.key === 'Enter' && !e.shiftKey) {
                            e.preventDefault();
                            this.sendMessage();
                        }
                    });
                    
                    input.addEventListener('input', this.autoResize.bind(this));
                }
            }

            autoResize(event) {
                event.target.style.height = 'auto';
                event.target.style.height = event.target.scrollHeight + 'px';
            }

            updateLanguage() {
                this.renderChat();
                this.messages = [];
                this.loadSampleMessages();
            }

            minimize() {
                const container = document.getElementById('chatContainer');
                container.classList.remove('active');
            }

            close() {
                const container = document.getElementById('chatContainer');
                const bubble = document.querySelector('.sb-chat-bubble');
                container.classList.remove('active');
                bubble.classList.remove('active');
            }

            toggleEmojiPicker() {
                showComingSoon('انتخاب ایموجی');
            }

            attachFile() {
                showComingSoon('ارسال فایل');
            }

            attachImage() {
                showComingSoon('ارسال عکس');
            }
        }

        // Chat toggle function
        function toggleChat() {
            const container = document.getElementById('chatContainer');
            const bubble = document.querySelector('.sb-chat-bubble');
            const badge = document.getElementById('chatBadge');
            
            container.classList.toggle('active');
            bubble.classList.toggle('active');
            
            if (container.classList.contains('active')) {
                badge.style.display = 'none';
                if (!chatInstance) {
                    chatInstance = new AdvancedChat();
                }
            }
        }
        
                // Generate stars
        function generateStars() {
            const starsContainer = document.getElementById('stars');
            const starCount = 150;

            for (let i = 0; i < starCount; i++) {
                const star = document.createElement('div');
                star.className = 'star';
                star.style.width = Math.random() * 3 + 'px';
                star.style.height = star.style.width;
                star.style.left = Math.random() * 100 + '%';
                star.style.top = Math.random() * 100 + '%';
                star.style.animationDelay = Math.random() * 3 + 's';
                starsContainer.appendChild(star);
            }
        }

        // Navigation
        function showPage(pageName) {
            // Hide all pages
            document.querySelectorAll('.page-content').forEach(page => {
                page.classList.remove('active');
            });

            // Show target page
            const targetPage = document.getElementById(pageName + 'Page');
            if (targetPage) {
                targetPage.classList.add('active');
            }

            // Update nav links
            document.querySelectorAll('.nav-link').forEach(link => {
                link.classList.remove('active');
                if (link.dataset.page === pageName) {
                    link.classList.add('active');
                }
            });

            // Scroll to top
            window.scrollTo({ top: 0, behavior: 'smooth' });

            // Close mobile menu if open
            const nav = document.getElementById('mainNav');
            if (nav.classList.contains('mobile-open')) {
                nav.classList.remove('mobile-open');
                document.querySelector('#menuToggle span').textContent = '☰';
            }
        }

        // Auth Modal
        function openAuthModal(mode) {
            const modal = document.getElementById('authModal');
            modal.classList.add('show');
            switchAuthMode(mode);
        }

        function closeAuthModal() {
            const modal = document.getElementById('authModal');
            modal.classList.remove('show');
        }

        function switchAuthMode(mode) {
            const loginForm = document.getElementById('loginForm');
            const signupForm = document.getElementById('signupForm');
            
            if (mode === 'login') {
                loginForm.style.display = 'block';
                signupForm.style.display = 'none';
            } else {
                loginForm.style.display = 'none';
                signupForm.style.display = 'block';
            }
        }

        function handleLogin(event) {
            event.preventDefault();
            
            // Simulate login
            currentUser = {
                name: 'Telbet User',
                email: 'user@telbet.com',
                initials: 'TU',
                balance: 1250.00
            };
            
            isLoggedIn = true;
            updateAuthUI();
            closeAuthModal();
            showToast('خوش آمدید! با موفقیت وارد شدید 🎮', 'success');
        }

        function handleSignup(event) {
            event.preventDefault();
            
            // Simulate signup
            currentUser = {
                name: 'New User',
                email: 'newuser@telbet.com',
                initials: 'NU',
                balance: 100.00
            };
            
            isLoggedIn = true;
            updateAuthUI();
            closeAuthModal();
            showToast('حساب کاربری ایجاد شد! به تلبت خوش آمدید! 🌟', 'success');
        }

        function updateAuthUI() {
            const authButtons = document.getElementById('authButtons');
            const userProfile = document.getElementById('userProfile');
            
            if (isLoggedIn && currentUser) {
                authButtons.style.display = 'none';
                userProfile.classList.add('active');
                
                document.getElementById('profileName').textContent = currentUser.name;
                document.getElementById('profileEmail').textContent = currentUser.email;
                document.getElementById('profileInitials').textContent = currentUser.initials;
                document.getElementById('profileBalance').textContent = '$' + currentUser.balance.toFixed(2);
            } else {
                authButtons.style.display = 'flex';
                userProfile.classList.remove('active');
            }
        }

        function toggleProfileDropdown() {
            const dropdown = document.getElementById('profileDropdown');
            dropdown.classList.toggle('show');
        }

        function logout() {
            currentUser = null;
            isLoggedIn = false;
            updateAuthUI();
            
            const dropdown = document.getElementById('profileDropdown');
            dropdown.classList.remove('show');
            
            showToast('با موفقیت خارج شدید. به امید دیدار! 👋', 'success');
            showPage('home');
        }

        // Close dropdown when clicking outside
        document.addEventListener('click', (e) => {
            const profile = document.getElementById('userProfile');
            const dropdown = document.getElementById('profileDropdown');
            
            if (profile && !profile.contains(e.target)) {
                dropdown.classList.remove('show');
            }
            
            // Close modals when clicking outside
            const authModal = document.getElementById('authModal');
            const comingSoonModal = document.getElementById('comingSoonModal');
            
            if (authModal.classList.contains('show') && e.target === authModal) {
                closeAuthModal();
            }
            
            if (comingSoonModal.classList.contains('show') && e.target === comingSoonModal) {
                closeComingSoonModal();
            }
        });

        // Toast Notification
        function showToast(message, type = 'success') {
            const toast = document.createElement('div');
            toast.className = `toast ${type}`;
            toast.textContent = message;
            document.body.appendChild(toast);
            
            setTimeout(() => {
                if (toast.parentNode) {
                    toast.parentNode.removeChild(toast);
                }
            }, 4000);
        }

        // Coming Soon Modal
        function showComingSoon(featureName) {
            const modal = document.getElementById('comingSoonModal');
            const messageElement = document.getElementById('comingSoonMessage');
            
            const messages = {
                fa: `ویژگی "${featureName}" در حال توسعه است و به زودی در دسترس قرار خواهد گرفت`,
                en: `The "${featureName}" feature is under development and will be available soon`
            };
            
            messageElement.textContent = messages[currentLanguage];
            modal.classList.add('show');
        }

        function closeComingSoonModal() {
            const modal = document.getElementById('comingSoonModal');
            modal.classList.remove('show');
        }

        // Mobile menu toggle
        function initializeMobileMenu() {
            const menuToggle = document.getElementById('menuToggle');
            const mainNav = document.getElementById('mainNav');

            if (menuToggle && mainNav) {
                menuToggle.addEventListener('click', () => {
                    mainNav.classList.toggle('mobile-open');
                    const icon = menuToggle.querySelector('span');
                    icon.textContent = mainNav.classList.contains('mobile-open') ? '✕' : '☰';
                });
            }
        }

        // Generate game data
        const casinoGames = [
            { name: 'Starburst Deluxe', category: 'Slots', icon: '🌟', rating: 4.8, players: '12.5K' },
            { name: 'Mega Fortune', category: 'Jackpot', icon: '💎', rating: 4.9, players: '8.2K' },
            { name: 'Book of Ra', category: 'Slots', icon: '📖', rating: 4.7, players: '15.1K' },
            { name: 'Roulette Royal', category: 'Table', icon: '🎡', rating: 4.6, players: '6.3K' },
            { name: 'Blackjack VIP', category: 'Table', icon: '🃏', rating: 4.8, players: '9.7K' },
            { name: 'Lucky Joker', category: 'Slots', icon: '🤡', rating: 4.5, players: '11.2K' },
            { name: 'Dragon\'s Fortune', category: 'Slots', icon: '🐉', rating: 4.9, players: '18.4K' },
            { name: 'Poker Master', category: 'Table', icon: '♠️', rating: 4.7, players: '7.8K' }
        ];

        const liveGames = [
            { name: 'Live Roulette Gold', category: 'Roulette', icon: '🎡', rating: 4.9, players: '2.1K' },
            { name: 'Blackjack Live Pro', category: 'Blackjack', icon: '🃏', rating: 4.8, players: '1.8K' },
            { name: 'Baccarat Supreme', category: 'Baccarat', icon: '💰', rating: 4.7, players: '1.5K' },
            { name: 'Texas Hold\'em Live', category: 'Poker', icon: '♠️', rating: 4.9, players: '3.2K' },
            { name: 'Lightning Roulette', category: 'Roulette', icon: '⚡', rating: 4.8, players: '2.7K' },
            { name: 'Speed Blackjack', category: 'Blackjack', icon: '🎯', rating: 4.6, players: '1.9K' }
        ];

        const sportsGames = [
            { name: 'Premier League', category: 'Football', icon: '⚽', rating: 4.9, players: '25.3K' },
            { name: 'NBA Live', category: 'Basketball', icon: '🏀', rating: 4.8, players: '18.7K' },
            { name: 'Grand Slam Tennis', category: 'Tennis', icon: '🎾', rating: 4.7, players: '12.4K' },
            { name: 'CS:GO Matches', category: 'E-Sports', icon: '🎮', rating: 4.9, players: '32.1K' },
            { name: 'UFC Fighting', category: 'MMA', icon: '🥊', rating: 4.8, players: '15.6K' },
            { name: 'Champions League', category: 'Football', icon: '🏆', rating: 4.9, players: '28.9K' }
        ];

        const promotions = [
            { 
                title: 'Welcome Bonus', 
                description: 'Get 200% bonus up to $2,000 on your first deposit plus 100 free spins on Starburst!',
                icon: '🎁',
                badge: 'NEW PLAYERS'
            },
            { 
                title: 'Weekend Reload', 
                description: 'Every weekend get 50% bonus up to $500 on any deposit. Valid Friday-Sunday!',
                icon: '⚡',
                badge: 'WEEKENDS'
            },
            { 
                title: 'VIP Cashback', 
                description: 'Get up to 20% cashback on all losses. The more you play, the more you earn back!',
                icon: '💎',
                badge: 'VIP ONLY'
            },
            { 
                title: 'Daily Free Spins', 
                description: 'Spin the wheel daily and win up to 200 free spins on selected games. No wagering!',
                icon: '🎰',
                badge: 'DAILY'
            }
        ];

        const faqs = [
            {
                question: 'How do I create an account?',
                answer: 'Click the "Sign up" button in the header, fill in your details, verify your email, and you\'re ready to play!'
            },
            {
                question: 'What payment methods do you accept?',
                answer: 'We accept credit/debit cards, e-wallets (PayPal, Skrill, Neteller), cryptocurrencies (Bitcoin, Ethereum), and bank transfers.'
            },
            {
                question: 'How long do withdrawals take?',
                answer: 'E-wallets and crypto withdrawals are instant. Card withdrawals take 1-3 business days. Bank transfers take 3-5 business days.'
            },
            {
                question: 'Is my personal information secure?',
                answer: 'Yes! We use 256-bit SSL encryption and comply with international data protection standards to keep your information safe.'
            },
            {
                question: 'Can I play on mobile?',
                answer: 'Absolutely! Our platform is fully optimized for mobile devices. Play on any smartphone or tablet with no app download needed.'
            },
            {
                question: 'Are the games fair?',
                answer: 'All our games use certified Random Number Generators (RNG) and are regularly audited by independent testing agencies.'
            }
        ];

        // Render games
        function renderGames(games, containerId) {
            const container = document.getElementById(containerId);
            if (!container) return;

            container.innerHTML = games.map(game => `
                <div class="game-card" onclick="showComingSoon('${game.name}')">
                    <div class="game-thumbnail">${game.icon}</div>
                    <div class="game-info">
                        <h3 class="game-title">${game.name}</h3>
                        <span class="game-category">${game.category}</span>
                        <div class="game-stats">
                            <div class="game-rating">
                                <span>⭐</span>
                                <span>${game.rating}</span>
                            </div>
                            <div>${game.players} playing</div>
                        </div>
                    </div>
                </div>
            `).join('');
        }

        // Render promotions
        function renderPromotions() {
            const container = document.getElementById('promotionsList');
            if (!container) return;

            container.innerHTML = promotions.map(promo => `
                <div class="feature-card" onclick="showComingSoon('${promo.title}')">
                    <div class="feature-icon">${promo.icon}</div>
                    <div style="display: inline-block; padding: 4px 12px; background: rgba(253, 211, 3, 0.15); border-radius: 9999px; font-size: 11px; color: #fdd303; margin-bottom: 16px; font-weight: 600;">${promo.badge}</div>
                    <h3 class="feature-title">${promo.title}</h3>
                    <p class="feature-description">${promo.description}</p>
                    <a class="feature-link" style="cursor: pointer;">
                        Claim Now
                        <span>→</span>
                    </a>
                </div>
            `).join('');
        }

        // Render FAQs
        function renderFAQs() {
            const container = document.getElementById('faqList');
            if (!container) return;

            container.innerHTML = faqs.map((faq, index) => `
                <div class="faq-item" onclick="toggleFAQ(${index})">
                    <div class="faq-question">
                        <span>${faq.question}</span>
                        <span class="faq-icon">▼</span>
                    </div>
                    <div class="faq-answer">${faq.answer}</div>
                </div>
            `).join('');
        }

        function toggleFAQ(index) {
            const items = document.querySelectorAll('.faq-item');
            items[index].classList.toggle('open');
        }

        function handleSupportForm(event) {
            event.preventDefault();
            showToast('پیام ارسال شد! ما در عرض 24 ساعت با شما تماس خواهیم گرفت. 💬', 'success');
            event.target.reset();
        }

        // Category tabs functionality
        function initializeCategoryTabs() {
            document.querySelectorAll('.category-tab').forEach(tab => {
                tab.addEventListener('click', function() {
                    // Remove active class from all tabs in the same container
                    this.parentElement.querySelectorAll('.category-tab').forEach(t => {
                        t.classList.remove('active');
                    });
                    
                    // Add active class to clicked tab
                    this.classList.add('active');
                    
                    // Show toast for demo
                    showToast(`دسته‌بندی "${this.textContent}" انتخاب شد`, 'success');
                });
            });
        }

        // Nav link handlers
        document.addEventListener('click', (e) => {
            if (e.target.classList.contains('nav-link')) {
                e.preventDefault();
                const page = e.target.dataset.page;
                if (page) {
                    showPage(page);
                }
            }
        });

        // Initialize everything when DOM is loaded
        document.addEventListener('DOMContentLoaded', () => {
            generateStars();
            initializeMobileMenu();
            initializeCategoryTabs();
            
            // Render all game sections
            renderGames(casinoGames, 'casinoGames');
            renderGames(liveGames, 'liveGames');
            renderGames(sportsGames, 'sportsGames');
            renderPromotions();
            renderFAQs();
            
            // Initialize with Persian language
            changeLanguage('fa');
            
            // Add click handlers for category tabs
            document.querySelectorAll('.category-tab').forEach(tab => {
                tab.addEventListener('click', function() {
                    this.parentElement.querySelectorAll('.category-tab').forEach(t => {
                        t.classList.remove('active');
                    });
                    this.classList.add('active');
                });
            });

            // Add enter key support for auth forms
            document.querySelectorAll('.form-input').forEach(input => {
                input.addEventListener('keypress', function(e) {
                    if (e.key === 'Enter') {
                        const form = this.closest('form');
                        if (form) {
                            const submitBtn = form.querySelector('button[type="submit"]');
                            if (submitBtn) {
                                submitBtn.click();
                            }
                        }
                    }
                });
            });

            // Initialize chat badge animation
            setInterval(() => {
                const badge = document.getElementById('chatBadge');
                if (badge && badge.style.display !== 'none') {
                    badge.style.animation = 'none';
                    setTimeout(() => {
                        badge.style.animation = 'bounce 0.5s ease';
                    }, 10);
                }
            }, 3000);
        });

        // Handle escape key for modals
        document.addEventListener('keydown', (e) => {
            if (e.key === 'Escape') {
                closeAuthModal();
                closeComingSoonModal();
                
                const dropdown = document.getElementById('profileDropdown');
                if (dropdown.classList.contains('show')) {
                    dropdown.classList.remove('show');
                }
            }
        });

        // Add smooth scrolling for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });

        // Add loading animation for better UX
        function showLoading() {
            const loading = document.createElement('div');
            loading.className = 'toast success';
            loading.textContent = 'در حال بارگذاری...';
            loading.style.background = 'linear-gradient(135deg, #2433d7 0%, #1850dc 100%)';
            document.body.appendChild(loading);
            
            setTimeout(() => {
                if (loading.parentNode) {
                    loading.parentNode.removeChild(loading);
                }
            }, 2000);
        }

        // Enhanced game card interactions
        document.addEventListener('mouseover', (e) => {
            if (e.target.closest('.game-card')) {
                const card = e.target.closest('.game-card');
                card.style.transform = 'translateY(-8px) scale(1.02)';
            }
        });

        document.addEventListener('mouseout', (e) => {
            if (e.target.closest('.game-card')) {
                const card = e.target.closest('.game-card');
                card.style.transform = 'translateY(-8px)';
            }
        });

        // Auto-hide dropdowns on scroll
        window.addEventListener('scroll', () => {
            const dropdown = document.getElementById('profileDropdown');
            if (dropdown.classList.contains('show')) {
                dropdown.classList.remove('show');
            }
        });

        // Enhanced mobile experience
        function checkTouchDevice() {
            if ('ontouchstart' in window || navigator.maxTouchPoints > 0) {
                document.body.classList.add('touch-device');
                
                // Add touch-specific improvements
                document.querySelectorAll('.game-card, .feature-card').forEach(card => {
                    card.style.cursor = 'pointer';
                });
            }
        }

        // Initialize touch device detection
        checkTouchDevice();

        // Performance optimization: Lazy loading for images
        if ('IntersectionObserver' in window) {
            const imageObserver = new IntersectionObserver((entries, observer) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        const img = entry.target;
                        img.src = img.dataset.src;
                        img.classList.remove('lazy');
                        imageObserver.unobserve(img);
                    }
                });
            });

            document.querySelectorAll('img[data-src]').forEach(img => {
                imageObserver.observe(img);
            });
        }

        console.log('🚀 Telbet Platform Initialized Successfully!');
        console.log('📧 Contact: support@telbet.com');
        console.log('🌐 Version: 2.0.0');
    </script>
</body>
</html>
    