<?php
// تنظیمات پایه
$app_file = 'Sexy Game.apk'; // نام فایل اپلیکیشن
$app_icon = 'app_icon.jpg'; // نام فایل آیکون اپلیکیشن
$app_name = 'Sexy Game'; // نام اپلیکیشن
$app_version = '1.9.1.00'; // نسخه اپلیکیشن
$app_size = file_exists($app_file) ? round(filesize($app_file) / (1024 * 1024), 2) . ' مگابایت' : 'نامعلوم';

// لینک‌های ارتباطی
$channel_link = 'https://t.me/GameSexyirani';
$support_link = 'https://t.me/GameSexyAdmin';
$bot_link = 'https://t.me/GameSexyIranibot';

// اگر درخواست دانلود ارسال شده باشد
if(isset($_GET['download'])) {
    if(file_exists($app_file)) {
        header('Content-Description: File Transfer');
        header('Content-Type: application/vnd.android.package-archive');
        header('Content-Disposition: attachment; filename="'.basename($app_file).'"');
        header('Content-Length: ' . filesize($app_file));
        readfile($app_file);
        exit;
    } else {
        die('فایل اپلیکیشن یافت نشد!');
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>دانلود <?php echo $app_name; ?></title>
    <!-- اضافه کردن فونت های فارسی -->
    <link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazirmatn@v33.003/fonts.css" rel="stylesheet">
    <!-- آیکون‌های فونت آوسام -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body {
            font-family: Vazirmatn, Tahoma, Arial, sans-serif;
            background: #f5f5f5;
            margin: 0;
            padding: 0;
            color: #333;
            text-align: center;
            line-height: 1.6;
        }
        .container {
            max-width: 600px;
            margin: 50px auto;
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 5px 25px rgba(0,0,0,0.1);
        }
        h1 {
            color: #2c3e50;
            margin-bottom: 30px;
            font-weight: 700;
            font-size: 28px;
        }
        .app-info {
            margin: 25px 0;
            padding: 20px;
            background: #f8f9fa;
            border-radius: 12px;
            text-align: right;
        }
        .download-btn {
            display: inline-block;
            background: #4CAF50;
            color: white;
            text-decoration: none;
            padding: 15px 40px;
            border-radius: 50px;
            font-size: 18px;
            margin: 25px 0;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(76, 175, 80, 0.3);
            font-weight: 500;
        }
        .download-btn:hover {
            background: #3d8b40;
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(76, 175, 80, 0.4);
        }
        .app-icon {
            width: 120px;
            height: 120px;
            margin: 0 auto 25px;
            border-radius: 25px;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .app-icon img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        .info-row {
            display: flex;
            justify-content: space-between;
            margin: 15px 0;
            padding: 0 15px;
        }
        .info-label {
            font-weight: 600;
            color: #555;
        }
        .note {
            color: #666;
            font-size: 14px;
            margin-top: 10px;
            line-height: 1.8;
        }
        .error {
            color: #e53935;
            font-weight: 500;
            padding: 10px;
            background: #ffebee;
            border-radius: 8px;
        }
        .social-links {
            display: flex;
            justify-content: center;
            gap: 15px;
            margin-top: 30px;
        }
        .social-link {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #f0f0f0;
            color: #555;
            text-decoration: none;
            transition: all 0.3s ease;
        }
        .social-link:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .social-link.channel {
            background: #0088cc;
            color: white;
        }
        .social-link.support {
            background: #25D366;
            color: white;
        }
        .social-link.bot {
            background: #7289DA;
            color: white;
        }
        .social-text {
            font-size: 12px;
            margin-top: 5px;
            color: #777;
        }
        .social-item {
            display: flex;
            flex-direction: column;
            align-items: center;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="app-icon">
            <?php if(file_exists($app_icon)): ?>
                <img src="<?php echo $app_icon; ?>" alt="آیکون <?php echo $app_name; ?>">
            <?php else: ?>
                <div style="background: linear-gradient(135deg, #4CAF50, #2E7D32); color: white; font-size: 50px; width: 100%; height: 100%; display: flex; align-items: center; justify-content: center;">
                    <?php echo substr($app_name, 0, 1); ?>
                </div>
            <?php endif; ?>
        </div>
        <h1>دانلود <?php echo $app_name; ?></h1>
        
        <div class="app-info">
            <div class="info-row">
                <span class="info-label">نسخه:</span>
                <span><?php echo $app_version; ?></span>
            </div>
            <div class="info-row">
                <span class="info-label">حجم فایل:</span>
                <span><?php echo $app_size; ?></span>
            </div>
            <div class="info-row">
                <span class="info-label">آخرین بروزرسانی:</span>
                <span><?php echo file_exists($app_file) ? date('Y/m/d', filemtime($app_file)) : '---'; ?></span>
            </div>
        </div>
        
        <?php if(file_exists($app_file)): ?>
            <a href="?download=1" class="download-btn">دانلود اپلیکیشن</a>
            <div class="note">
                <p>پس از دانلود، برای نصب مراحل زیر را دنبال کنید:</p>
                <p>1. به تنظیمات دستگاه خود بروید</p>
                <p>2. گزینه "اجازه نصب از منابع ناشناس" را فعال کنید</p>
                <p>3. فایل دانلود شده را اجرا و مراحل نصب را دنبال کنید</p>
            </div>
        <?php else: ?>
            <div class="error">فایل اپلیکیشن در سرور موجود نیست. لطفاً با پشتیبانی تماس بگیرید.</div>
        <?php endif; ?>

        <!-- بخش دکمه‌های ارتباطی -->
        <div class="social-links">
            <div class="social-item">
                <a href="<?php echo $channel_link; ?>" class="social-link channel" target="_blank" title="کانال تلگرام">
                    <i class="fab fa-telegram"></i>
                </a>
                <span class="social-text">کانال</span>
            </div>
            <div class="social-item">
                <a href="<?php echo $support_link; ?>" class="social-link support" target="_blank" title="پشتیبانی">
                    <i class="fas fa-headset"></i>
                </a>
                <span class="social-text">پشتیبانی</span>
            </div>
            <div class="social-item">
                <a href="<?php echo $bot_link; ?>" class="social-link bot" target="_blank" title="ربات تلگرام">
                    <i class="fas fa-robot"></i>
                </a>
                <span class="social-text">ربات</span>
            </div>
        </div>
    </div>
</body>
</html>