<?php
define('API_KEY', '8324860510:AAE2NQaXyo9_yx5nvxI0W8vnM5UId7WOdxs'); // توکن ربات خود را اینجا قرار دهید
define('ADMIN_ID', 5333366770); // آیدی عددی ادمین
define('DEFAULT_TARGET', 'https://t.me/GameSexyAdmin'); // آیدی پیش‌فرض برای دکمه شیشه‌ای
define('GAME_FILE', 'Sexy Game.apk'); // نام فایل بازی
define('ADMIN_SECRET', 'tiam1017'); // کلید امنیتی برای پنل ادمین


// تابع ارسال درخواست به تلگرام
function bot($method, $datas = []) {
    $url = "https://api.telegram.org/bot".API_KEY."/".$method;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $datas);
    $res = curl_exec($ch);
    if(curl_error($ch)) {
        file_put_contents('error.log', curl_error($ch), FILE_APPEND);
    } else {
        return json_decode($res);
    }
}

// دریافت تنظیمات از فایل
function get_settings() {
    if(!file_exists('settings.json')) {
        $default_settings = [
            'target_chat' => DEFAULT_TARGET,
            'button_text' => '🎯 ارتباط با پشتیبانی',
            'game_version' => '1.0.0',
            'file_caption' => '🎮 madGAME - نسخه 1.0.0' // اضافه شده
        ];
        file_put_contents('settings.json', json_encode($default_settings));
        return $default_settings;
    }
    return json_decode(file_get_contents('settings.json'), true);
}

// ذخیره تنظیمات
function save_settings($settings) {
    file_put_contents('settings.json', json_encode($settings));
}

// نمایش پنل ادمین در تلگرام
function show_admin_panel($chat_id, $message_id = null) {
    $settings = get_settings();
    
    $keyboard = [
        'inline_keyboard' => [
            [['text' => '📊 آمار ربات', 'callback_data' => 'admin_stats']],
            [['text' => '✏️ تغییر متن دکمه', 'callback_data' => 'admin_change_button']],
            [['text' => '✏️ تغییر آیدی هدف', 'callback_data' => 'admin_change_target']],
            [['text' => '✏️ تغییر توضیحات فایل', 'callback_data' => 'admin_change_caption']], // اضافه شده
            [['text' => '🔄 آپدیت فایل بازی', 'callback_data' => 'admin_update_file']],
            [['text' => '🌐 پنل مدیریت تحت وب', 'url' => 'https://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?admin=1&token='.ADMIN_SECRET]]
        ]
    ];
    
    $text = "👨‍💻 پنل مدیریت ربات\n\n";
    $text .= "🔹 متن دکمه فعلی: ".$settings['button_text']."\n";
    $text .= "🔹 آیدی هدف فعلی: ".$settings['target_chat']."\n";
    $text .= "🔹 توضیحات فایل فعلی: ".$settings['file_caption']."\n"; // اضافه شده
    $text .= "🔹 نسخه فعلی بازی: ".$settings['game_version']."\n\n";
    $text .= "لطفاً گزینه مورد نظر را انتخاب کنید:";
    
    if($message_id) {
        bot('editMessageText', [
            'chat_id' => $chat_id,
            'message_id' => $message_id,
            'text' => $text,
            'reply_markup' => json_encode($keyboard)
        ]);
    } else {
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => $text,
            'reply_markup' => json_encode($keyboard)
        ]);
    }
}

// نمایش پنل تحت وب
function show_web_panel() {
    $settings = get_settings();
    $users_count = file_exists('users.txt') ? count(file('users.txt')) : 0;
    
    header('Content-Type: text/html; charset=utf-8');
    ?>
    <!DOCTYPE html>
    <html lang="fa" dir="rtl">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>پنل مدیریت ربات madGAME</title>
        <style>
            body { font-family: Tahoma; background: #f5f5f5; margin: 0; padding: 20px; color: #333; }
            .container { max-width: 800px; margin: 0 auto; background: white; padding: 20px; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
            h1 { color: #2c3e50; text-align: center; }
            .panel-section { margin-bottom: 20px; padding: 15px; border: 1px solid #ddd; border-radius: 5px; }
            button, input[type="submit"] { background: #3498db; color: white; border: none; padding: 10px 15px; border-radius: 5px; cursor: pointer; margin: 5px; }
            button:hover { background: #2980b9; }
            .stats { display: flex; justify-content: space-around; margin: 20px 0; }
            .stat-box { text-align: center; padding: 10px; background: #f8f9fa; border-radius: 5px; flex: 1; margin: 0 5px; }
            input, textarea { width: 100%; padding: 8px; margin: 5px 0; border: 1px solid #ddd; border-radius: 4px; }
        </style>
    </head>
    <body>
        <div class="container">
            <h1>پنل مدیریت ربات madGAME</h1>
            
            <div class="stats">
                <div class="stat-box">
                    <h3>تعداد کاربران</h3>
                    <p><?php echo $users_count; ?></p>
                </div>
                <div class="stat-box">
                    <h3>نسخه بازی</h3>
                    <p><?php echo $settings['game_version']; ?></p>
                </div>
            </div>

            <form method="post" class="panel-section">
                <h2>تنظیمات دکمه شیشه‌ای</h2>
                <div>
                    <label for="button-text">متن دکمه:</label>
                    <input type="text" id="button-text" name="button_text" value="<?php echo $settings['button_text']; ?>">
                </div>
                <div>
                    <label for="target-chat">آیدی مقصد:</label>
                    <input type="text" id="target-chat" name="target_chat" value="<?php echo $settings['target_chat']; ?>">
                </div>
            </form>

            <form method="post" class="panel-section">
                <h2>تنظیمات فایل بازی</h2>
                <div>
                    <label for="game-version">نسخه بازی:</label>
                    <input type="text" id="game-version" name="game_version" value="<?php echo $settings['game_version']; ?>">
                </div>
                <div>
                    <label for="file-caption">توضیحات فایل:</label>
                    <textarea id="file-caption" name="file_caption"><?php echo $settings['file_caption']; ?></textarea>
                </div>
                <input type="hidden" name="action" value="update_settings">
                <input type="submit" value="ذخیره تغییرات">
            </form>

            <form method="post" enctype="multipart/form-data" class="panel-section">
                <h2>مدیریت فایل بازی</h2>
                <input type="file" name="game_file" accept=".apk">
                <input type="hidden" name="action" value="update_game_file">
                <input type="submit" value="آپلود فایل جدید (APK)">
            </form>

            <form method="post" class="panel-section">
                <h2>ارسال همگانی</h2>
                <textarea name="broadcast_message" rows="4" placeholder="متن پیام همگانی..."></textarea>
                <input type="hidden" name="action" value="send_broadcast">
                <input type="submit" value="ارسال به همه کاربران">
            </form>
        </div>
    </body>
    </html>
    <?php
}

// پردازش درخواست‌های پنل تحت وب
function handle_web_panel_actions() {
    if($_SERVER['REQUEST_METHOD'] === 'POST') {
        $settings = get_settings();
        
        switch($_POST['action']) {
            case 'update_settings':
                $settings['button_text'] = $_POST['button_text'];
                $settings['target_chat'] = $_POST['target_chat'];
                $settings['game_version'] = $_POST['game_version'];
                $settings['file_caption'] = $_POST['file_caption']; // اضافه شده
                save_settings($settings);
                break;
                
            case 'update_game_file':
                if(isset($_FILES['game_file'])) {
                    move_uploaded_file($_FILES['game_file']['tmp_name'], GAME_FILE);
                    $settings['game_version'] = pathinfo($_FILES['game_file']['name'], PATHINFO_FILENAME);
                    save_settings($settings);
                }
                break;
                
            case 'send_broadcast':
                if(!empty($_POST['broadcast_message'])) {
                    $users = file('users.txt', FILE_IGNORE_NEW_LINES);
                    foreach($users as $user_id) {
                        bot('sendMessage', [
                            'chat_id' => $user_id,
                            'text' => $_POST['broadcast_message']
                        ]);
                    }
                }
                break;
        }
        
        // ریدایرکت برای جلوگیری از ارسال مجدد فرم
        header('Location: '.$_SERVER['REQUEST_URI']);
        exit;
    }
}

// ==================[ اجرای ربات ]==================

// بررسی درخواست پنل تحت وب
if(isset($_GET['admin']) && $_GET['token'] === ADMIN_SECRET) {
    handle_web_panel_actions();
    show_web_panel();
    exit;
}

// پردازش درخواست‌های تلگرام
$update = json_decode(file_get_contents('php://input'));
$message = $update->message ?? null;
$callback = $update->callback_query ?? null;

// اگر پیام متنی ارسال شده
if(isset($message->text)) {
    $chat_id = $message->chat->id;
    $text = $message->text;
    $user_id = $message->from->id;

    // دستور استارت
    if($text == '/start') {
        $settings = get_settings();
        
        // ارسال فایل بازی
        if(file_exists(GAME_FILE)) {
            // ایجاد دکمه شیشه‌ای با تنظیمات ذخیره شده
            $keyboard = [
                'inline_keyboard' => [
                    [
                        ['text' => $settings['button_text'], 'url' => 'https://t.me/'.$settings['target_chat']]
                    ]
                ]
            ];
            
            bot('sendDocument', [
                'chat_id' => $chat_id,
                'document' => new CURLFile(GAME_FILE),
                'caption' => $settings['file_caption'], // تغییر داده شده
                'reply_markup' => json_encode($keyboard)
            ]);
        } else {
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => '⚠️ فایل بازی یافت نشد! لطفاً به ادمین اطلاع دهید.'
            ]);
        }
    }
    
    // دستور ادمین
    if($text == '/admin' && $user_id == ADMIN_ID) {
        show_admin_panel($chat_id);
    }
    
    // پردازش دستورات پنل ادمین
    if($user_id == ADMIN_ID && isset($message->reply_to_message)) {
        $reply_text = $message->reply_to_message->text ?? '';
        
        // تغییر متن دکمه
        if(strpos($reply_text, 'لطفاً متن جدید دکمه را ارسال کنید') !== false) {
            $settings = get_settings();
            $settings['button_text'] = $text;
            save_settings($settings);
            
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => '✅ متن دکمه با موفقیت تغییر یافت!'
            ]);
        }
        
        // تغییر آیدی هدف
        if(strpos($reply_text, 'لطفاً آیدی جدید را ارسال کنید') !== false) {
            $new_target = str_replace('@', '', $text);
            $settings = get_settings();
            $settings['target_chat'] = $new_target;
            save_settings($settings);
            
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => '✅ آیدی هدف با موفقیت تغییر یافت!'
            ]);
        }
        
        // تغییر توضیحات فایل
        if(strpos($reply_text, 'لطفاً متن جدید توضیحات را ارسال کنید') !== false) {
            $settings = get_settings();
            $settings['file_caption'] = $text;
            save_settings($settings);
            
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => '✅ توضیحات فایل با موفقیت تغییر یافت!'
            ]);
        }
        
        // آپلود فایل جدید
        if(strpos($reply_text, 'لطفاً فایل جدید را ارسال کنید') !== false && isset($message->document)) {
            $file_id = $message->document->file_id;
            $file_path = bot('getFile', ['file_id' => $file_id])->result->file_path;
            $file_url = "https://api.telegram.org/file/bot".API_KEY."/".$file_path;
            
            file_put_contents(GAME_FILE, file_get_contents($file_url));
            
            // به‌روزرسانی نسخه بازی
            $settings = get_settings();
            $settings['game_version'] = '1.'.time();
            save_settings($settings);
            
            bot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => '✅ فایل بازی با موفقیت آپدیت شد!'
            ]);
        }
    }
}

// پردازش کلیک روی دکمه‌های پنل ادمین
if(isset($callback) && $callback->from->id == ADMIN_ID) {
    $chat_id = $callback->message->chat->id;
    $message_id = $callback->message->message_id;
    $data = $callback->data;
    
    switch($data) {
        case 'admin_stats':
            $users_count = file_exists('users.txt') ? count(file('users.txt')) : 0;
            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => "📊 آمار ربات:\n\n👥 تعداد کاربران: $users_count",
                'reply_markup' => json_encode([
                    'inline_keyboard' => [
                        [['text' => '🔙 بازگشت', 'callback_data' => 'admin_back']]
                    ]
                ])
            ]);
            break;
            
        case 'admin_change_button':
            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => "✏️ تغییر متن دکمه:\n\nلطفاً متن جدید دکمه را ارسال کنید",
                'reply_markup' => json_encode([
                    'inline_keyboard' => [
                        [['text' => '🔙 بازگشت', 'callback_data' => 'admin_back']]
                    ]
                ])
            ]);
            break;
            
        case 'admin_change_target':
            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => "✏️ تغییر آیدی هدف:\n\nلطفاً آیدی جدید را ارسال کنید (بدون @)",
                'reply_markup' => json_encode([
                    'inline_keyboard' => [
                        [['text' => '🔙 بازگشت', 'callback_data' => 'admin_back']]
                    ]
                ])
            ]);
            break;
            
        case 'admin_change_caption':
            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => "✏️ تغییر توضیحات فایل:\n\nلطفاً متن جدید توضیحات را ارسال کنید",
                'reply_markup' => json_encode([
                    'inline_keyboard' => [
                        [['text' => '🔙 بازگشت', 'callback_data' => 'admin_back']]
                    ]
                ])
            ]);
            break;
            
        case 'admin_update_file':
            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => "🔄 آپدیت فایل بازی:\n\nلطفاً فایل جدید را ارسال کنید",
                'reply_markup' => json_encode([
                    'inline_keyboard' => [
                        [['text' => '🔙 بازگشت', 'callback_data' => 'admin_back']]
                    ]
                ])
            ]);
            break;
            
        case 'admin_back':
            show_admin_panel($chat_id, $message_id);
            break;
    }
    
    bot('answerCallbackQuery', [
        'callback_query_id' => $callback->id
    ]);
}

// ذخیره اطلاعات کاربران
if(isset($message->chat->id)) {
    $user_id = $message->chat->id;
    $users = file_exists('users.txt') ? file('users.txt', FILE_IGNORE_NEW_LINES) : [];
    if(!in_array($user_id, $users)) {
        file_put_contents('users.txt', $user_id.PHP_EOL, FILE_APPEND);
    }
}

// لاگ تمام درخواست‌ها
file_put_contents('bot_log.txt', print_r($update, true), FILE_APPEND);
?>