<?php
require_once 'config.php';

if (!isLoggedIn()) {
    redirect('index.php');
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $user_id = $_SESSION['user_id'];
    $type = $_POST['type'];
    $name = $_POST['name'];
    $national_id = $_POST['national_id'];
    $date = $_POST['date'];
    $meal_type = $_POST['meal_type'];
    
    // ذخیره اطلاعات رزرو در دیتابیس
    $stmt = $pdo->prepare("INSERT INTO reservations (user_id, type, name, national_id, date, meal_type, amount, status, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, 'pending', NOW())");
    $stmt->execute([$user_id, $type, $name, $national_id, $date, $meal_type, PAYMENT_AMOUNT]);
    $reservation_id = $pdo->lastInsertId();
    
    // در اینجا باید کد اتصال به درگاه پرداخت قرار گیرد
    // برای نمونه، یک درگاه پرداخت ساده شبیه‌سازی می‌شود
    
    $_SESSION['reservation_id'] = $reservation_id;
    
    // شبیه‌سازی پرداخت موفق
    $stmt = $pdo->prepare("UPDATE reservations SET status = 'paid', payment_date = NOW() WHERE id = ?");
    $stmt->execute([$reservation_id]);
    
    // افزایش اعتبار کاربر
    $stmt = $pdo->prepare("UPDATE users SET balance = balance + ? WHERE id = ?");
    $stmt->execute([PAYMENT_AMOUNT, $user_id]);
    
    $_SESSION['success'] = "پرداخت با موفقیت انجام شد و رزرو شما ثبت گردید";
    redirect('history.php');
}

redirect('dashboard.php');
?>