<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>پنل کاربری - بازی سکسی</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #6A11CB;
            --primary-hover: #4A00E0;
            --secondary: #F0F0F0;
            --accent: #FF6B8B;
            --light: #FAFAFA;
            --dark: #2D3436;
            --success: #00B894;
            --border-radius: 20px;
            --box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Vazirmatn', sans-serif;
        }

        body {
            background: linear-gradient(-20deg, #6A11CB 0%, #4A00E0 100%);
            color: #2D3436;
            min-height: 100vh;
            padding: 20px 0;
            background-attachment: fixed;
        }

        .container {
            width: 100%;
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }

        /* هدر و منو */
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(10px);
            border-radius: var(--border-radius);
            padding: 15px 25px;
            margin-bottom: 30px;
            box-shadow: var(--box-shadow);
        }

        .logo {
            font-weight: 800;
            font-size: 1.8rem;
            color: white;
            display: flex;
            align-items: center;
        }

        .menu-icon {
            font-size: 1.5rem;
            color: white;
            cursor: pointer;
            transition: var(--transition);
        }

        .menu-icon:hover {
            transform: rotate(90deg);
        }

        /* محتوای اصلی */
        .main-content {
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            overflow: hidden;
            margin-bottom: 30px;
        }

        .status-section {
            padding: 40px;
            text-align: center;
            background: linear-gradient(135deg, #fdfcfb 0%, #f5f7fa 100%);
        }

        .status-icon {
            font-size: 4rem;
            margin-bottom: 20px;
            color: var(--primary);
        }

        .status-title {
            font-weight: 800;
            font-size: 2rem;
            color: var(--primary);
            margin-bottom: 15px;
        }

        .status-text {
            font-size: 1.2rem;
            color: #666;
            line-height: 1.8;
            margin-bottom: 10px;
        }

        .phone-number {
            background: var(--primary);
            color: white;
            padding: 10px 20px;
            border-radius: 50px;
            display: inline-block;
            margin: 15px 0;
            font-weight: 600;
            font-size: 1.2rem;
        }

        /* بخش پلن‌ها */
        .plans-section {
            padding: 40px;
            background: white;
        }

        .section-title {
            font-weight: 700;
            color: var(--primary);
            font-size: 1.8rem;
            margin-bottom: 30px;
            text-align: center;
        }

        .plans-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 25px;
        }

        .plan-card {
            background: var(--light);
            border-radius: var(--border-radius);
            padding: 25px;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            transition: var(--transition);
            position: relative;
            cursor: pointer;
            border: 2px solid transparent;
        }

        .plan-card.locked {
            opacity: 0.7;
        }

        .plan-card.locked:after {
            content: "🔒";
            position: absolute;
            top: 15px;
            left: 15px;
            font-size: 1.5rem;
        }

        .plan-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
            border-color: var(--primary);
        }

        .plan-icon {
            font-size: 2.5rem;
            margin-bottom: 15px;
            color: var(--primary);
        }

        .plan-title {
            font-weight: 700;
            font-size: 1.3rem;
            margin-bottom: 10px;
            color: var(--dark);
        }

        .plan-description {
            color: #666;
            line-height: 1.6;
        }

        /* پنل پروفایل */
        .profile-panel {
            position: fixed;
            top: 0;
            right: -400px;
            width: 380px;
            height: 100vh;
            background: white;
            box-shadow: -5px 0 25px rgba(0, 0, 0, 0.15);
            z-index: 1000;
            transition: var(--transition);
            padding: 30px;
            overflow-y: auto;
        }

        .profile-panel.active {
            right: 0;
        }

        .panel-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px solid #eee;
        }

        .panel-title {
            font-weight: 700;
            font-size: 1.5rem;
            color: var(--primary);
        }

        .close-panel {
            font-size: 1.5rem;
            color: #999;
            cursor: pointer;
            transition: var(--transition);
        }

        .close-panel:hover {
            color: var(--accent);
            transform: rotate(90deg);
        }

        .profile-info {
            margin-bottom: 30px;
        }

        .info-group {
            margin-bottom: 20px;
        }

        .info-label {
            font-weight: 600;
            color: #666;
            margin-bottom: 5px;
            display: block;
        }

        .info-value {
            font-size: 1.1rem;
            color: var(--dark);
            padding: 10px 15px;
            background: #f9f9f9;
            border-radius: var(--border-radius);
        }

        .overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 999;
            display: none;
        }

        .overlay.active {
            display: block;
        }

        /* مودال ارور */
        .modal {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background: white;
            border-radius: var(--border-radius);
            padding: 30px;
            box-shadow: var(--box-shadow);
            z-index: 1001;
            text-align: center;
            display: none;
            width: 90%;
            max-width: 400px;
        }

        .modal.active {
            display: block;
        }

        .modal-icon {
            font-size: 3rem;
            color: var(--accent);
            margin-bottom: 20px;
        }

        .modal-title {
            font-weight: 700;
            font-size: 1.5rem;
            margin-bottom: 15px;
            color: var(--dark);
        }

        .modal-text {
            color: #666;
            line-height: 1.6;
            margin-bottom: 25px;
        }

        .modal-close {
            background: var(--primary);
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: 50px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
        }

        .modal-close:hover {
            background: var(--primary-hover);
            transform: translateY(-3px);
        }

        /* رسپانسیو */
        @media (max-width: 768px) {
            .plans-grid {
                grid-template-columns: 1fr;
            }
            
            .profile-panel {
                width: 100%;
                right: -100%;
            }
            
            .status-section {
                padding: 25px;
            }
            
            .status-title {
                font-size: 1.6rem;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- هدر و منو -->
        <div class="header">
            <div class="logo">🎮 بازی سکسی</div>
            <div class="menu-icon" onclick="openProfilePanel()">
                <i class="fas fa-bars"></i>
            </div>
        </div>

        <!-- محتوای اصلی -->
        <div class="main-content">
            <!-- بخش وضعیت -->
            <div class="status-section">
                <div class="status-icon">⏳</div>
                <h1 class="status-title">در انتظار فعال سازی</h1>
                <p class="status-text">اشتراک شما توسط ادمین ما در حال بررسی و فعال سازی است.</p>
                <p class="status-text">پس از فعال سازی، اطلاعات اکانت شما به شماره زیر ارسال خواهد شد:</p>
                <div class="phone-number" id="user-phone">09123456789</div>
                <p class="status-text">لطفا تا دریافت اطلاعات اکانت، شکیبا باشید.</p>
            </div>

            <!-- بخش پلن‌ها -->
            <div class="plans-section">
                <h2 class="section-title">پلن‌های بازی ما</h2>
                <div class="plans-grid">
                    <div class="plan-card locked" onclick="showError()">
                        <div class="plan-icon">👭</div>
                        <h3 class="plan-title">لزبین</h3>
                        <p class="plan-description">تجربه بازی برای علاقه‌مندان به سبک لزبین</p>
                    </div>
                    <div class="plan-card locked" onclick="showError()">
                        <div class="plan-icon">🌈</div>
                        <h3 class="plan-title">گی</h3>
                        <p class="plan-description">تجربه بازی برای علاقه‌مندان به سبک گی</p>
                    </div>
                    <div class="plan-card locked" onclick="showError()">
                        <div class="plan-icon">👨‍👩‍👧</div>
                        <h3 class="plan-title">تری سام</h3>
                        <p class="plan-description">تجربه بازی برای علاقه‌مندان به سبک تری سام</p>
                    </div>
                    <div class="plan-card locked" onclick="showError()">
                        <div class="plan-icon">🧘‍♂️</div>
                        <h3 class="plan-title">ریلکس و مدرن</h3>
                        <p class="plan-description">تجربه بازی برای علاقه‌مندان به سبک ریلکس و مدرن</p>
                    </div>
                    <div class="plan-card locked" onclick="showError()">
                        <div class="plan-icon">💆‍♂️</div>
                        <h3 class="plan-title">ماساژی</h3>
                        <p class="plan-description">تجربه بازی برای علاقه‌مندان به سبک ماساژی</p>
                    </div>
                    <div class="plan-card locked" onclick="showError()">
                        <div class="plan-icon">🔥</div>
                        <h3 class="plan-title">خشن</h3>
                        <p class="plan-description">تجربه بازی برای علاقه‌مندان به سبک خشن</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- پنل پروفایل -->
    <div class="profile-panel" id="profilePanel">
        <div class="panel-header">
            <h2 class="panel-title">پروفایل کاربری</h2>
            <div class="close-panel" onclick="closeProfilePanel()">
                <i class="fas fa-times"></i>
            </div>
        </div>

        <div class="profile-info">
            <div class="info-group">
                <label class="info-label">نام کاربری در بازی</label>
                <div class="info-value" id="profile-username">username123</div>
            </div>
            <div class="info-group">
                <label class="info-label">نام</label>
                <div class="info-value" id="profile-firstname">علی</div>
            </div>
            <div class="info-group">
                <label class="info-label">نام خانوادگی</label>
                <div class="info-value" id="profile-lastname">رضایی</div>
            </div>
            <div class="info-group">
                <label class="info-label">ایمیل</label>
                <div class="info-value" id="profile-email">ali.rezaei@example.com</div>
            </div>
            <div class="info-group">
                <label class="info-label">شماره تلفن</label>
                <div class="info-value" id="profile-phone">09123456789</div>
            </div>
            <div class="info-group">
                <label class="info-label">سن</label>
                <div class="info-value" id="profile-age">28 سال</div>
            </div>
            <div class="info-group">
                <label class="info-label">جنسیت</label>
                <div class="info-value" id="profile-gender">آقا</div>
            </div>
            <div class="info-group">
                <label class="info-label">سبک بازی انتخاب شده</label>
                <div class="info-value" id="profile-style">ریلکس و مدرن</div>
            </div>
        </div>

        <div class="sticker-placeholder">
            <img src="https://via.placeholder.com/250x250/f5f5f5/666666?text=Sticker+Placeholder" alt="استیکر" style="max-width: 100%; border-radius: 10px;">
            <p style="margin-top: 10px; color: #666;">فضای قرارگیری استیکر یا گیف</p>
        </div>
    </div>

    <!-- overlay -->
    <div class="overlay" id="overlay" onclick="closeProfilePanel()"></div>

    <!-- مودال خطا -->
    <div class="modal" id="errorModal">
        <div class="modal-icon">⛔</div>
        <h2 class="modal-title">اشتراک فعال نیست</h2>
        <p class="modal-text">اشتراک شما هنوز فعال نشده است. لطفا تا فعال شدن اشتراک منتظر بمانید.</p>
        <button class="modal-close" onclick="closeModal()">متوجه شدم</button>
    </div>

    <script>
        // شبیه‌سازی داده‌های کاربر - در حالت واقعی از دیتابیس گرفته می‌شود
        const userData = {
            username: "username123",
            firstname: "علی",
            lastname: "رضایی",
            email: "ali.rezaei@example.com",
            phone: "09123456789",
            age: "28 سال",
            gender: "آقا",
            style: "ریلکس و مدرن"
        };

        // نمایش اطلاعات کاربر در صفحه
        document.getElementById('user-phone').textContent = userData.phone;
        document.getElementById('profile-username').textContent = userData.username;
        document.getElementById('profile-firstname').textContent = userData.firstname;
        document.getElementById('profile-lastname').textContent = userData.lastname;
        document.getElementById('profile-email').textContent = userData.email;
        document.getElementById('profile-phone').textContent = userData.phone;
        document.getElementById('profile-age').textContent = userData.age;
        document.getElementById('profile-gender').textContent = userData.gender;
        document.getElementById('profile-style').textContent = userData.style;

        // باز کردن پنل پروفایل
        function openProfilePanel() {
            document.getElementById('profilePanel').classList.add('active');
            document.getElementById('overlay').classList.add('active');
        }

        // بستن پنل پروفایل
        function closeProfilePanel() {
            document.getElementById('profilePanel').classList.remove('active');
            document.getElementById('overlay').classList.remove('active');
        }

        // نمایش خطا هنگام کلیک روی پلن‌ها
        function showError() {
            document.getElementById('errorModal').classList.add('active');
            document.getElementById('overlay').classList.add('active');
        }

        // بستن مودال
        function closeModal() {
            document.getElementById('errorModal').classList.remove('active');
            document.getElementById('overlay').classList.remove('active');
        }
    </script>
</body>
</html>