<?php
// بررسی وضعیت لاگین
$is_logged_in = isset($_SESSION['user_id']);
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نسیم رضوان - سامانه رزرو غذا</title>
    <link rel="stylesheet" href="styles/style.css">
    <link href="https://cdn.jsdelivr.net/gh/rastikerdar/sahel-font@v3.4.0/dist/font-face.css" rel="stylesheet">
    <style>
        @font-face {
            font-family: 'Sahel';
            src: url('https://cdn.jsdelivr.net/gh/rastikerdar/sahel-font@v3.4.0/dist/Sahel.ttf');
        }
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
            font-family: 'Sahel', sans-serif;
        }
        body {
            background-image: url('images/background_pattern.png');
            background-size: cover;
            background-attachment: fixed;
            margin: 0;
            padding: 0;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }
        .main-container {
            width: 100%;
            max-width: 500px;
            margin: 20px auto;
            padding: 0 15px;
        }
        .header {
            background-image: url('images/header_background.png');
            background-size: cover;
            border-radius: 15px 15px 0 0;
            padding: 15px;
            color: white;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.5);
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        .logo-container {
            display: flex;
            align-items: center;
        }
        .logo {
            height: 50px;
            margin-left: 10px;
        }
        .header-text {
            text-align: right;
        }
        .header h1 {
            margin: 0;
            font-size: 1.5rem;
        }
        .header p {
            margin: 5px 0 0;
            font-size: 0.9rem;
        }
        .main-content {
            background-color: rgba(255, 255, 255, 0.95);
            border-radius: 0 0 15px 15px;
            padding: 20px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }
        .shrine-image {
            margin: 20px 0;
            text-align: center;
        }
        .shrine-image img {
            max-width: 100%;
            height: auto;
            border-radius: 10px;
        }
        .btn-primary {
            width: 100%;
            padding: 12px;
            background-color: #2B91AF;
            color: white;
            border: none;
            border-radius: 5px;
            font-family: 'Sahel', sans-serif;
            font-size: 1rem;
            cursor: pointer;
            margin-top: 10px;
        }
        .btn-primary:hover {
            background-color: #1e7ba5;
        }
        .btn-secondary {
            width: 100%;
            padding: 10px;
            background-color: #6c757d;
            color: white;
            border: none;
            border-radius: 5px;
            font-family: 'Sahel', sans-serif;
            font-size: 0.9rem;
            cursor: pointer;
            text-align: center;
            text-decoration: none;
            display: block;
            margin-top: 15px;
        }
        .btn-secondary:hover {
            background-color: #5a6268;
        }
        .form-group {
            margin-bottom: 20px;
            text-align: right;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-size: 0.9rem;
            color: #333;
        }
        .form-group input, .form-group select {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-family: 'Sahel', sans-serif;
            text-align: right;
        }
        .captcha-container {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .captcha-container img {
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 5px;
            background-color: #f9f9f9;
        }
        .user-info {
            text-align: center;
            padding: 10px 0;
            margin-bottom: 15px;
            border-bottom: 1px solid #eee;
        }
        .user-info p {
            margin: 5px 0;
            color: #555;
        }
        .options-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 15px;
            margin: 20px 0;
        }
        .option-card {
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            text-align: center;
            border: 1px solid #eee;
            transition: transform 0.2s;
        }
        .option-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .option-card h4 {
            margin-bottom: 10px;
            color: #2c5e2e;
        }
        .reservation-item {
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 15px;
            border: 1px solid #eee;
        }
        .reservation-info p {
            margin-bottom: 8px;
        }
        .status-paid {
            color: #28a745;
            font-weight: bold;
        }
        .status-pending {
            color: #dc3545;
            font-weight: bold;
        }
        .price {
            color: #2c5e2e;
            font-weight: bold;
            font-size: 18px;
        }
        .empty-state {
            text-align: center;
            padding: 40px 0;
            color: #666;
        }
        .footer {
            text-align: center;
            padding: 15px;
            color: #666;
            font-size: 0.8rem;
        }
        @media (max-width: 480px) {
            .options-grid {
                grid-template-columns: 1fr;
            }
            .main-container {
                padding: 0 10px;
            }
        }
    </style>
</head>
<body>
    <div class="main-container">
        <div class="header">
            <div class="logo-container">
                <img src="images/logo.png" alt="لوگو نسیم رضوان" class="logo">
            </div>
            <div class="header-text">
                <h1>نسیم رضوان</h1>
                <p>app.nasimghozvan.com</p>
            </div>
        </div>
        
        <div class="main-content">
            <?php if ($is_logged_in): ?>
            <div class="user-info">
                <p>شماره موبایل: <?php echo $_SESSION['mobile']; ?></p>
            </div>
            <?php endif; ?>