<?php
require_once 'config.php';
require_once 'includes/header.php';

if (!isLoggedIn()) {
    redirect('index.php');
}

$user_id = $_SESSION['user_id'];

// دریافت سوابق رزرو کاربر
$stmt = $pdo->prepare("SELECT * FROM reservations WHERE user_id = ? ORDER BY created_at DESC");
$stmt->execute([$user_id]);
$reservations = $stmt->fetchAll();
?>

<div class="main-content">
    <div class="history-section">
        <h2>سوابق رزرو</h2>
        
        <?php if (empty($reservations)): ?>
            <div class="empty-state">
                <p>هنوز سابقه‌ای ندارید.</p>
            </div>
        <?php else: ?>
            <div class="reservations-list">
                <?php foreach ($reservations as $reservation): ?>
                    <div class="reservation-item">
                        <div class="reservation-info">
                            <p><strong>نوع:</strong> <?php echo $reservation['type']; ?></p>
                            <p><strong>نام:</strong> <?php echo $reservation['name']; ?></p>
                            <p><strong>تاریخ:</strong> <?php echo $reservation['date']; ?></p>
                            <p><strong>وعده غذایی:</strong> <?php echo $reservation['meal_type']; ?></p>
                            <p><strong>مبلغ:</strong> <?php echo number_format($reservation['amount']); ?> تومان</p>
                            <p><strong>وضعیت:</strong> 
                                <span class="status-<?php echo $reservation['status']; ?>">
                                    <?php 
                                    if ($reservation['status'] == 'paid') {
                                        echo 'پرداخت شده';
                                    } else {
                                        echo 'در انتظار پرداخت';
                                    }
                                    ?>
                                </span>
                            </p>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php
require_once 'includes/footer.php';
?>