CREATE DATABASE nasimghozvan_db CHARACTER SET utf8 COLLATE utf8_persian_ci;

USE nasimghozvan_db;

CREATE TABLE users (
    id INT(11) AUTO_INCREMENT PRIMARY KEY,
    mobile VARCHAR(11) NOT NULL UNIQUE,
    balance INT(11) DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE reservations (
    id INT(11) AUTO_INCREMENT PRIMARY KEY,
    user_id INT(11) NOT NULL,
    type VARCHAR(50) NOT NULL,
    name VARCHAR(100) NOT NULL,
    national_id VARCHAR(10) NOT NULL,
    date DATE NOT NULL,
    meal_type VARCHAR(20) NOT NULL,
    amount INT(11) NOT NULL,
    status ENUM('pending', 'paid', 'failed') DEFAULT 'pending',
    payment_date TIMESTAMP NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id)
);