<?php
session_start();

// ایجاد کپچا
$chars = '0123456789';
$captcha_code = substr(str_shuffle($chars), 0, 6);
$_SESSION['captcha_code'] = $captcha_code;

// ایجاد تصویر کپچا
$image = imagecreatetruecolor(150, 50);

// رنگ‌ها
$bg_color = imagecolorallocate($image, 240, 240, 240); // پس‌زمینه روشن
$text_color = imagecolorallocate($image, 40, 40, 40); // متن تیره
$noise_color = imagecolorallocate($image, 100, 100, 100); // برای نویز

// پر کردن پس‌زمینه
imagefilledrectangle($image, 0, 0, 150, 50, $bg_color);

// اضافه کردن نویز (خطوط تصادفی)
for ($i = 0; $i < 5; $i++) {
    imageline($image, rand(0, 150), rand(0, 50), rand(0, 150), rand(0, 50), $noise_color);
}

// اضافه کردن نقاط تصادفی
for ($i = 0; $i < 100; $i++) {
    imagesetpixel($image, rand(0, 150), rand(0, 50), $noise_color);
}

// مسیر فونت - اگر فونت ندارید، از فونت پیش فرض GD استفاده کنید
$font = 5; // فونت پیش فرض داخلی GD

// استفاده از فونت پیش فرض GD
imagestring($image, $font, 50, 15, $captcha_code, $text_color);

// ارسال تصویر
header('Content-type: image/png');
imagepng($image);
imagedestroy($image);
?>